/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.filter;

import com.xebialabs.license.filter.LicenseCheckFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;

public class LicenseRegistrationCheckFilter
extends LicenseCheckFilter {
    private static final String ALLOWED_URL = "/deployit/server/license/reload";

    private boolean isAcceptedHtml(HttpServletRequest httpRequest) {
        String headerValue = httpRequest.getHeader("Accept");
        return headerValue != null && Arrays.asList(headerValue.split(",")).contains("text/html");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String registerUrl = "/register";
        String uri = httpRequest.getRequestURI();
        boolean isDummy = this.licenseService.getLicense().isDummyLicense();
        boolean isRegisterBased = uri.startsWith(registerUrl);
        if (uri.equals(ALLOWED_URL)) {
            super.doFilter(request, response, chain);
            return;
        }
        if (!isDummy && isRegisterBased) {
            httpResponse.sendRedirect("/");
            return;
        }
        if (isDummy && !isRegisterBased) {
            if (!this.isAcceptedHtml(httpRequest)) {
                httpResponse.setStatus(403);
            } else {
                httpResponse.sendRedirect(registerUrl);
            }
            return;
        }
        super.doFilter(request, response, chain);
    }
}

