package com.xebialabs.deployit.jetty;

import java.io.IOException;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;

public class NoOptionsFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if(request instanceof HttpServletRequest && ((HttpServletRequest) request).getMethod().equals("OPTIONS")) {
            throw new IllegalArgumentException("OPTIONS not supported");
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }

}
