package com.xebialabs.ascode.yaml.writer

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.model.permission.PermissionsSpec
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig

object PermissionWriter extends SpecWriter {
  override def write(spec: Spec, yamlGenerator: YAMLGenerator)(implicit mapper: ObjectMapper, config: WriterConfig): GenerateContext = {
    val permissionsSpec = spec.asInstanceOf[PermissionsSpec]
    mapper.writeValue(yamlGenerator, permissionsSpec.permissions)
    GenerateContext()
  }
}
