package com.xebialabs.ascode.yaml.parser.util

trait IdResolver {
  def resolveCiId(name: String, ciType: String, parentId: Option[String]): String
  def resolveReferenceId(name: String, parentId: Option[String]): String
}

object IdentityIdResolver extends IdResolver {
  override def resolveCiId(name: String,
                           ciType: String,
                           parentId: Option[String]): String = name

  override def resolveReferenceId(name: String,
                                  parentId: Option[String]): String = name
}