package com.xebialabs.deployit.core.rest

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type

import com.xebialabs.ascode.yaml.dto.PreviewResponse
import jakarta.ws.rs.Produces
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyWriter, Provider}
import org.springframework.stereotype.Component

@Component
@Provider
@Produces(Array("application/json"))
class PreviewResponseMessageBodyWriter extends MessageBodyWriter[PreviewResponse] with JsonSupport {
  override def isWriteable(`type`: Class[_],
                           genericType: Type,
                           annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[PreviewResponse].isAssignableFrom(`type`)

  override def writeTo(t: PreviewResponse,
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = jsonMapper.writeValue(entityStream, t)
}
