package com.xebialabs.deployit.core.rest

import com.xebialabs.ascode.annotation.ExceptionToAsCodeResponse
import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.deployit.core.rest.resteasy.WorkdirInjectorFactory
import jakarta.ws.rs.ext.Provider
import org.jboss.resteasy.core.{InjectorFactoryImpl, MethodInjectorImpl}
import org.jboss.resteasy.spi.metadata.ResourceLocator
import org.jboss.resteasy.spi.{HttpRequest, HttpResponse, MethodInjector, ResteasyProviderFactory}
import org.springframework.aop.support.AopUtils
import org.springframework.stereotype.Component

@Component
@Provider
class AsCodeExceptionWrapperFactory(workDirInjector: WorkdirInjectorFactory) extends InjectorFactoryImpl {
  class AsCodeExceptionWrapperMethodInjector(method: ResourceLocator, factory: ResteasyProviderFactory)
    extends MethodInjectorImpl(method, factory) {
    private val methodInjector = workDirInjector.createMethodInjector(method, factory)

    override def invoke(request: HttpRequest, httpResponse: HttpResponse, resource: Any): AnyRef = {
      val clazz = AopUtils.getTargetClass(resource)
      val realMethod = clazz.getMethod(method.getMethod.getName, method.getMethod.getParameterTypes: _*)
      val annotation = classOf[ExceptionToAsCodeResponse]
      if (realMethod.isAnnotationPresent(annotation) || clazz.isAnnotationPresent(annotation)) {
        AsCodeException.wrapUnhandled(methodInjector.invoke(request, httpResponse, resource))
      } else methodInjector.invoke(request, httpResponse, resource)
    }
  }

  override def createMethodInjector(method: ResourceLocator, factory: ResteasyProviderFactory): MethodInjector =
    new AsCodeExceptionWrapperMethodInjector(method, factory)
}
