package com.xebialabs.ascode.yaml.parser.support

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.xltype.serialization.{CiListReader, CiReader}

import scala.jdk.CollectionConverters._

class JacksonCiListReader(node: JsonNode,
                          parentReader: Option[CiReader],
                          config: ReaderConfig)
                         (implicit mapper: ObjectMapper) extends CiListReader {
  private def getReferencesArray = node
    .iterator()
    .asScala
    .toList
    .map(node => if (node.isObject) node else {
      val obj = mapper.createObjectNode()
      obj.put("ci-ref", node.asText())
      obj
    })

  private val iterator = getReferencesArray.iterator
  private var currentNode: JsonNode = _

  override def hasMoreChildren: Boolean = iterator.hasNext

  override def moveIntoChild(): Unit = currentNode = iterator.next()

  override def moveOutOfChild(): Unit = {}

  override def getCurrentCiReader: CiReader = {
    val reader = new JacksonCiReader(currentNode, parentReader, config)
    if (currentNode.has("ci-ref")) {
      reader.moveIntoProperty()
    }
    reader
  }
}
