package com.xebialabs.ascode.yaml.parser

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.model.permission.{GlobalPermissionRelation, PermissionRelation, PermissionsSpec, RolePermissionsRelation}

import scala.collection.convert.ImplicitConversions._

object PermissionSpecParser {
  def apply(delegate: JsonNode => PermissionRelation): PermissionSpecParser =
    new PermissionSpecParser(delegate)
}

class PermissionSpecParser(delegate: JsonNode => PermissionRelation) extends SpecParser {
  private def parseGlobalPermissions(global: JsonNode): GlobalPermissionRelation = {
    val permissions = global.elements.toList.map(RolePermissionsRelation.parse)
    GlobalPermissionRelation(permissions)
  }

  private def parseFolderPermissions(folder: JsonNode): PermissionRelation = delegate(folder)

  override def parse(definitionKind: String,
                     metadata: Option[Map[String, String]],
                     node: JsonNode)
                    (implicit mapper: ObjectMapper): Spec = {
    val permissions = node.elements().map {
      case element if element.has("global") => parseGlobalPermissions(element.get("global"))
      case element => parseFolderPermissions(element)
    }.toList

    if (permissions.count(_.isInstanceOf[GlobalPermissionRelation]) > 1) {
      AsCodeException.throwDocumentFieldException("spec", "Duplicate 'global' definitions are not supported.")
    }

    PermissionsSpec(permissions)
  }
}
