package com.xebialabs.deployit.ascode.yaml.writer

import java.io.OutputStream

import com.xebialabs.ascode.yaml.model.User
import com.xebialabs.ascode.yaml.sugar.SugarConfig
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.ascode.yaml.writer.{DefinitionWriter, PermissionWriter, RolesWriter, UsersWriter}
import com.xebialabs.deployit.ascode.repository.WorkDirConstants.AS_CODE_GENERATE_PREFIX
import com.xebialabs.deployit.ascode.yaml.model.Constants.Kinds._
import com.xebialabs.deployit.ascode.yaml.writer.spec.CiSpecWriter
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder

object XLDDefinitionWriter {
  private def definitionWriter(implicit config: SugarConfig) = DefinitionWriter(
    "xl-deploy",
    List(INFRASTRUCTURE, ENVIRONMENTS, APPLICATIONS, CONFIGURATION) -> new CiSpecWriter,
    List(PERMISSIONS) -> PermissionWriter,
    List(ROLES) -> RolesWriter,
    List(USERS) -> new UsersWriter[User]()
  )

  def write(out: OutputStream, writerConfig: WriterConfig)(implicit config: SugarConfig): Unit = {
    WorkdirHolder.initWorkdir(AS_CODE_GENERATE_PREFIX)
    definitionWriter(config).write(out, writerConfig)
  }
}