/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.PreviewResponse;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.deployit.ascode.service.StitchPreviewService;
import com.xebialabs.deployit.ascode.service.spec.util.DeploymentPreparationService;
import com.xebialabs.deployit.ascode.yaml.model.Constants$Kinds$;
import com.xebialabs.deployit.ascode.yaml.model.DeploymentSpec;
import com.xebialabs.deployit.core.rest.DryRunResource;
import com.xebialabs.deployit.core.rest.PreviewResource;
import com.xebialabs.deployit.core.rest.view.PreviewResult;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.dto.ChangeSetDto;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.DryRunDeploymentDto;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.ParallelBlock;
import com.xebialabs.deployit.engine.tasker.Phase;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.SerialBlock;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001\u0002\u0007\u000e\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\"B\"\u0001\t\u0003!\u0005\"B&\u0001\t\u0013a\u0005\"\u00028\u0001\t\u0013y\u0007\"CA\u0004\u0001E\u0005I\u0011BA\u0005\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!!\u0011\u0001\t\u0003\t\u0019E\u0001\bQe\u00164\u0018.Z<TKJ4\u0018nY3\u000b\u00059y\u0011aB:feZL7-\u001a\u0006\u0003!E\ta!Y:d_\u0012,'B\u0001\n\u0014\u0003!!W\r\u001d7ps&$(B\u0001\u000b\u0016\u0003%AXMY5bY\u0006\u00147OC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0012I\u0016\u0004Hn\\=nK:$8+\u001a:wS\u000e,\u0007CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\r\t\u0007/\u001b\u0006\u0003KE\ta!\u001a8hS:,\u0017BA\u0014#\u0005E!U\r\u001d7ps6,g\u000e^*feZL7-Z\u0001\u0016gRLGo\u00195Qe\u00164\u0018.Z<SKN|WO]2f!\tQs&D\u0001,\u0015\taS&\u0001\u0003sKN$(B\u0001\u0018\u0012\u0003\u0011\u0019wN]3\n\u0005AZ#a\u0004)sKZLWm\u001e*fg>,(oY3\u0002)M$\u0018\u000e^2i!J,g/[3x'\u0016\u0014h/[2f!\t\u0019D'D\u0001\u000e\u0013\t)TB\u0001\u000bTi&$8\r\u001b)sKZLWm^*feZL7-Z\u0001\u000fIJL(+\u001e8SKN|WO]2f!\tQ\u0003(\u0003\u0002:W\tqAI]=Sk:\u0014Vm]8ve\u000e,\u0017\u0001\b3fa2|\u00170\\3oiB\u0013X\r]1sCRLwN\\*feZL7-\u001a\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA!\u001e;jY*\u0011\u0001)D\u0001\u0005gB,7-\u0003\u0002C{\taB)\u001a9m_flWM\u001c;Qe\u0016\u0004\u0018M]1uS>t7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0004F\r\u001eC\u0015J\u0013\t\u0003g\u0001AQa\b\u0004A\u0002\u0001BQ\u0001\u000b\u0004A\u0002%BQ!\r\u0004A\u0002IBQA\u000e\u0004A\u0002]BQA\u000f\u0004A\u0002m\n!\u0003\u001e:b]N4wN]7Ti\u0016\u00048\u000b^1uKR\u0011QJ\u001a\t\u0003\u001d\u000et!a\u00141\u000f\u0005AkfBA)[\u001d\t\u0011\u0016L\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011akF\u0001\u0007yI|w\u000e\u001e \n\u0003YI!\u0001F\u000b\n\u0005A\u0019\u0012BA.]\u0003\u0011I\u0018-\u001c7\u000b\u0005A\u0019\u0012B\u00010`\u0003\r!Go\u001c\u0006\u00037rK!!\u00192\u0002\u001fA\u0013XM^5foJ+7\u000f]8og\u0016T!AX0\n\u0005\u0011,'a\u0004+bg.\u0004&/\u001a<jK^LE/Z7\u000b\u0005\u0005\u0014\u0007\"B4\b\u0001\u0004A\u0017!C:uKB\u001cF/\u0019;f!\tIG.D\u0001k\u0015\tY'%A\u0005fq\u0016\u001cW\u000f^5p]&\u0011QN\u001b\u0002\n'R,\u0007o\u0015;bi\u0016\f1\u0003\u001e:b]N4wN]7CY>\u001c7n\u0015;bi\u0016$2\u0001]=\u007f!\r\th/\u0014\b\u0003eRt!\u0001V:\n\u0003qI!!^\u000e\u0002\u000fA\f7m[1hK&\u0011q\u000f\u001f\u0002\u0005\u0019&\u001cHO\u0003\u0002v7!)!\u0010\u0003a\u0001w\u0006Q!\r\\8dWN#\u0018\r^3\u0011\u0005%d\u0018BA?k\u0005)\u0011En\\2l'R\fG/\u001a\u0005\t\u007f\"\u0001\n\u00111\u0001\u0002\u0002\u0005Q\u0011n\u001d)be\u0006dG.\u001a7\u0011\u0007i\t\u0019!C\u0002\u0002\u0006m\u0011qAQ8pY\u0016\fg.A\u000fue\u0006t7OZ8s[\ncwnY6Ti\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tYA\u000b\u0003\u0002\u0002\u000551FAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e1$\u0001\u0006b]:|G/\u0019;j_:LA!!\b\u0002\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\u001d,G\u000fV1tW\u0012+7o\u0019:jaRLwN\u001c\u000b\u0005\u0003G\t\u0019\u0004\u0005\u0003\u0002&\u00055b\u0002BA\u0014\u0003S\u0001\"\u0001V\u000e\n\u0007\u0005-2$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003WY\u0002bBA\u001b\u0015\u0001\u0007\u0011qG\u0001\u000bI\u0016\u0004Hn\\=nK:$\b\u0003BA\u001d\u0003{i!!a\u000f\u000b\u0005y\u0013\u0013\u0002BA \u0003w\u0011!\u0002R3qY>LX.\u001a8u\u0003\u001d\u0001(/\u001a<jK^$B!!\u0012\u0002NA!\u0011qIA%\u001b\u0005\u0011\u0017bAA&E\ny\u0001K]3wS\u0016<(+Z:q_:\u001cX\rC\u0004\u0002P-\u0001\r!!\u0015\u0002\u0015\u0011,g-\u001b8ji&|g\u000e\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9fX\u0001\u0006[>$W\r\\\u0005\u0005\u00037\n)F\u0001\u0006EK\u001aLg.\u001b;j_:D3\u0001AA0!\u0011\t\t'!\u001e\u000e\u0005\u0005\r$\u0002BA\r\u0003KRA!a\u001a\u0002j\u00059a-Y2u_JL(\u0002BA6\u0003[\nQAY3b]NTA!a\u001c\u0002r\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002t\u0005\u0019qN]4\n\t\u0005]\u00141\r\u0002\n\u0003V$xn^5sK\u0012D3\u0001AA>!\u0011\ti(a!\u000e\u0005\u0005}$\u0002BAA\u0003[\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t))a \u0003\u000fM+'O^5dK\u0002")
public class PreviewService {
    private final DeploymentService deploymentService;
    private final PreviewResource stitchPreviewResource;
    private final StitchPreviewService stitchPreviewService;
    private final DryRunResource dryRunResource;
    private final DeploymentPreparationService deploymentPreparationService;

    private PreviewResponse.TaskPreviewItem transformStepState(StepState stepState) {
        return new PreviewResponse.TaskPreviewItem(stepState.getDescription(), (List)Nil$.MODULE$, PreviewResponse.TaskPreviewItem$.MODULE$.apply$default$3());
    }

    private List<PreviewResponse.TaskPreviewItem> transformBlockState(BlockState blockState, boolean isParallel) {
        BlockState blockState2;
        while (true) {
            if ((blockState2 = blockState) instanceof PhaseContainer) {
                PhaseContainer phaseContainer = (PhaseContainer)blockState2;
                List children = phaseContainer.phases().toList().flatMap((Function1 & Serializable)x$1 -> this.transformBlockState((BlockState)x$1, this.transformBlockState$default$2()));
                return (List)Option$.MODULE$.apply((Object)phaseContainer.description()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)))).map((Function1 & Serializable)desc -> {
                    PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(desc, children, isParallel);
                    return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
                }).getOrElse((Function0 & Serializable)() -> children);
            }
            if (blockState2 instanceof ParallelBlock) {
                ParallelBlock parallelBlock = (ParallelBlock)blockState2;
                String description = parallelBlock.description();
                Seq blocks = parallelBlock.blocks();
                PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(description, blocks.toList().flatMap((Function1 & Serializable)x$3 -> this.transformBlockState((BlockState)x$3, true)), isParallel);
                return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
            }
            if (blockState2 instanceof SerialBlock) {
                SerialBlock serialBlock = (SerialBlock)blockState2;
                String description = serialBlock.description();
                Seq blocks = serialBlock.blocks();
                PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(description, blocks.toList().flatMap((Function1 & Serializable)x$4 -> this.transformBlockState((BlockState)x$4, this.transformBlockState$default$2())), isParallel);
                return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
            }
            if (blockState2 instanceof StepBlockState) {
                StepBlockState stepBlockState = (StepBlockState)blockState2;
                PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(stepBlockState.getDescription(), CollectionConverters$.MODULE$.ListHasAsScala(stepBlockState.getSteps()).asScala().toList().map((Function1 & Serializable)stepState -> this.transformStepState((StepState)stepState)), isParallel);
                return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
            }
            if (!(blockState2 instanceof Phase)) break;
            Phase phase = (Phase)blockState2;
            isParallel = this.transformBlockState$default$2();
            blockState = phase.block();
        }
        if (blockState2 instanceof Block) {
            Block block = (Block)blockState2;
            PreviewResponse.TaskPreviewItem taskPreviewItem = new PreviewResponse.TaskPreviewItem(block.description(), CollectionConverters$.MODULE$.ListHasAsScala(block.getStepList()).asScala().toList().map((Function1 & Serializable)stepState -> this.transformStepState((StepState)stepState)), isParallel);
            return Nil$.MODULE$.$colon$colon((Object)taskPreviewItem);
        }
        return Nil$.MODULE$;
    }

    private boolean transformBlockState$default$2() {
        return false;
    }

    private String getTaskDescription(Deployment deployment) {
        String string;
        Deployment.DeploymentType deploymentType = deployment.getDeploymentType();
        if (Deployment.DeploymentType.INITIAL.equals(deploymentType)) {
            string = "deployed to";
        } else if (Deployment.DeploymentType.UPDATE.equals(deploymentType)) {
            string = "updated on";
        } else if (Deployment.DeploymentType.UNDEPLOYMENT.equals(deploymentType)) {
            string = "un-deployed from";
        } else {
            throw new MatchError((Object)deploymentType);
        }
        String typeRelatedPart = string;
        ConfigurationItem configurationItem = deployment.getDeployedApplication();
        if (configurationItem instanceof DeployedApplication) {
            DeployedApplication deployedApplication = (DeployedApplication)configurationItem;
            return "Application '" + deployedApplication.getVersion().getId() + "' will be " + typeRelatedPart + " '" + deployedApplication.getEnvironment().getId() + "'";
        }
        throw new MatchError((Object)configurationItem);
    }

    public PreviewResponse preview(Definition definition) {
        String string = definition.kind();
        String string2 = Constants$Kinds$.MODULE$.DEPLOYMENT();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            DeploymentSpec spec = (DeploymentSpec)definition.spec();
            Deployment deployment = this.deploymentPreparationService.deploymentSpecToDeployment(spec);
            TaskPreviewBlock taskPreviewBlock = this.deploymentService.taskPreviewBlock(deployment);
            List<PreviewResponse.TaskPreviewItem> taskPreviewItems = this.transformBlockState(taskPreviewBlock.getBlock(), this.transformBlockState$default$2());
            return new PreviewResponse((Option)new Some((Object)new PreviewResponse.TaskInfo(this.getTaskDescription(deployment), taskPreviewItems)));
        }
        String string3 = definition.kind();
        String string4 = Constants$Kinds$.MODULE$.STITCH_PREVIEW();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            DeploymentSpec spec = (DeploymentSpec)definition.spec();
            Deployment deployment = this.deploymentPreparationService.deploymentSpecToDeployment(spec);
            PreviewResult stitchPreviewBlock = this.stitchPreviewResource.preview(deployment);
            List<PreviewResponse.TaskPreviewItem> stitchPreviewItems = this.stitchPreviewService.transformStitchPreviewResult(stitchPreviewBlock);
            return new PreviewResponse((Option)new Some((Object)new PreviewResponse.TaskInfo(this.stitchPreviewService.getStitchTaskDescription(deployment, "Generating stitch preview for the deployment of application"), stitchPreviewItems)));
        }
        String string5 = definition.kind();
        String string6 = Constants$Kinds$.MODULE$.STITCH_DRYRUN();
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            DeploymentSpec spec = (DeploymentSpec)definition.spec();
            Deployment deployment = this.deploymentPreparationService.deploymentSpecToDeployment(spec);
            PreviewResult dryRunPreviewResult = this.dryRunResource.dryRun(new DryRunDeploymentDto(new ChangeSetDto(spec.stitchSource(), spec.branchName()), deployment));
            List<PreviewResponse.TaskPreviewItem> stitchPreviewItems = this.stitchPreviewService.transformStitchPreviewResult(dryRunPreviewResult);
            return new PreviewResponse((Option)new Some((Object)new PreviewResponse.TaskInfo(this.stitchPreviewService.getStitchTaskDescription(deployment, "Generating DryRun preview on CI '" + spec.stitchSource() + "' and branch '" + spec.branchName() + "' for the deployment of application"), stitchPreviewItems)));
        }
        throw new AsCodeException("Cannot preview '" + definition.kind() + "' spec. Only '" + Constants$Kinds$.MODULE$.DEPLOYMENT() + "' and '" + Constants$Kinds$.MODULE$.STITCH_PREVIEW() + "' spec kind are supported.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
    }

    public PreviewService(DeploymentService deploymentService, PreviewResource stitchPreviewResource, StitchPreviewService stitchPreviewService, DryRunResource dryRunResource, DeploymentPreparationService deploymentPreparationService) {
        this.deploymentService = deploymentService;
        this.stitchPreviewResource = stitchPreviewResource;
        this.stitchPreviewService = stitchPreviewService;
        this.dryRunResource = dryRunResource;
        this.deploymentPreparationService = deploymentPreparationService;
    }
}

