package com.xebialabs.deployit.core.rest.support

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type

import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.deployit.ascode.yaml.sugar.XLDSugar.defaultConfig
import com.xebialabs.deployit.ascode.yaml.writer.XLDDefinitionWriter
import jakarta.ws.rs.Produces
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyWriter, Provider}
import org.springframework.stereotype.Component

@Component
@Provider
@Produces(Array("application/zip"))
class WriterConfigMessageBodyWriter extends MessageBodyWriter[WriterConfig] {
  override def isWriteable(`type`: Class[_],
                           genericType: Type,
                           annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[WriterConfig].isAssignableFrom(`type`)

  override def getSize(config: WriterConfig,
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  override def writeTo(config: WriterConfig,
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = XLDDefinitionWriter.write(entityStream, config)
}
