package com.xebialabs.deployit.ascode.service.generator

import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.ascode.yaml.model.permission.{GlobalPermissionRelation, PermissionsSpec, RolePermissionsRelation}
import com.xebialabs.deployit.ascode.service.generator.DefinitionGeneratorService.GeneratorConfig
import com.xebialabs.deployit.ascode.yaml.model.permission.DirectoryPermissionsRelation
import com.xebialabs.deployit.core.rest.api.SecurityResource
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.core.Directory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import com.xebialabs.deployit.ascode.yaml.model.Constants.Versions._
import com.xebialabs.deployit.ascode.yaml.model.Constants.Kinds._
import com.xebialabs.deployit.core.api.InternalSecurityProxy
import com.xebialabs.deployit.security.GLOBAL_SECURITY_ALIAS
import com.xebialabs.ascode.utils.Utils._

import scala.jdk.CollectionConverters._

@Component
@Autowired
class PermissionsDefinitionGenerator(securityResource: SecurityResource,
                                     internalSecurityProxy: InternalSecurityProxy) extends DefinitionGenerator {
  private def getDirectoryPermissionsRelation(dirId: String) = {
    val rolePermissions = securityResource.readRolePermissions(dirId, null, null, null).asScala.toList
    val relations = rolePermissions.map(rel => RolePermissionsRelation(rel.getRole.getName, rel.getPermissions.asScala.toList))
    if (relations.nonEmpty) Some(DirectoryPermissionsRelation(dirId, relations)) else None
  }

  private def generateFolderPermissions(cis: List[ConfigurationItem]): List[DirectoryPermissionsRelation] =
    cis
      .to(LazyList)
      .filter {
        case _: Directory => true
        case _ => false
      }
      .map(_.getId)
      .flatMap(getDirectoryPermissionsRelation)
      .toList

  private def generateGlobalPermissions(config: GeneratorConfig): List[GlobalPermissionRelation] = {
    val result = if (config.globalPermissions) {
      val permissions = internalSecurityProxy
        .readRolePermissions(GLOBAL_SECURITY_ALIAS, null, null, null)
        .asScala
        .map(relation => RolePermissionsRelation(relation.getRole.getName, relation.getPermissions.asScala.toList))
        .toList
      if (permissions.nonEmpty) Some(GlobalPermissionRelation(permissions)) else None
    } else None
    result.toList
  }

  private def generateRootNodePermissions(entryPointId: Option[String]): List[DirectoryPermissionsRelation] =
    entryPointId
      .filter(_.isRootNode)
      .flatMap(getDirectoryPermissionsRelation)
      .toList

  override def generate(config: GeneratorConfig, cis: List[ConfigurationItem]): List[Definition] = {
    val permissions = generateGlobalPermissions(config) :::
      generateFolderPermissions(cis) :::
      generateRootNodePermissions(config.ciId)
    if (permissions.nonEmpty) {
      val spec = PermissionsSpec(permissions)
      Definition(XLD_API_VERSION, None, PERMISSIONS, spec) :: Nil
    } else Nil
  }
}
