/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ascode.service.spec.util;

import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.deployit.ascode.yaml.model.DeploymentSpec;
import com.xebialabs.deployit.core.util.IdExtensions$;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeploymentTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.reflect.ScalaSignature;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\u0006\f\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!)\u0001\u0007\u0001C\u0001c!)a\u0007\u0001C\u0005o!)\u0011\u000b\u0001C\u0001%\")A\f\u0001C\u0005;\")1\r\u0001C\u0005I\")\u0001\u000e\u0001C\u0001S\")1\u000e\u0001C\u0001Y\naB)\u001a9m_flWM\u001c;Qe\u0016\u0004\u0018M]1uS>t7+\u001a:wS\u000e,'B\u0001\u0007\u000e\u0003\u0011)H/\u001b7\u000b\u00059y\u0011\u0001B:qK\u000eT!\u0001E\t\u0002\u000fM,'O^5dK*\u0011!cE\u0001\u0007CN\u001cw\u000eZ3\u000b\u0005Q)\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005Y9\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0012aA2p[\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u0006)B-\u001a9m_flWM\u001c;UCN\\7+\u001a:wS\u000e,\u0007CA\u0012(\u001b\u0005!#BA\u0013'\u0003)!W\r\u001d7ps6,g\u000e\u001e\u0006\u0003!MI!\u0001\u000b\u0013\u0003+\u0011+\u0007\u000f\\8z[\u0016tG\u000fV1tWN+'O^5dK\u0006\t\"/\u001a9pg&$xN]=TKJ4\u0018nY3\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\u001a\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011q\u0006\f\u0002\u0012%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u00023iU\u0002\"a\r\u0001\u000e\u0003-AQ!I\u0002A\u0002\tBQ!K\u0002A\u0002)\n\u0011\u0003\u001d:fa\u0006\u0014X\rR3qY>LX.\u001a8u)\rA$i\u0014\t\u0003s\u0001k\u0011A\u000f\u0006\u0003wq\n1\u0001\u001a;p\u0015\tid(A\u0002ba&T!aP\n\u0002\r\u0015tw-\u001b8f\u0013\t\t%H\u0001\u0006EKBdw._7f]RDQa\u0011\u0003A\u0002\u0011\u000bqA^3sg&|g\u000e\u0005\u0002F\u0019:\u0011aI\u0013\t\u0003\u000fvi\u0011\u0001\u0013\u0006\u0003\u0013f\ta\u0001\u0010:p_Rt\u0014BA&\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-k\u0002\"\u0002)\u0005\u0001\u0004!\u0015aC3om&\u0014xN\\7f]R\f1\u0003\u001d:fa\u0006\u0014X-\u00168EKBdw._7f]R$\"\u0001O*\t\u000b9)\u0001\u0019\u0001+\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016!B7pI\u0016d'BA-\u0012\u0003\u0011I\u0018-\u001c7\n\u0005m3&A\u0004#fa2|\u00170\\3oiN\u0003XmY\u0001 M&dG.\u00138EKBdw._3e\u0003B\u0004H.[2bi&|gNR5fY\u0012\u001cHc\u00010bEB\u0011AdX\u0005\u0003Av\u0011A!\u00168ji\")QE\u0002a\u0001q!)aB\u0002a\u0001)\u00069\"/Z1e\t\u0016\u0004Hn\\=fI\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0004=\u0016<\u0007\"\u00024\b\u0001\u0004A\u0014\u0001D;o\t\u0016\u0004Hn\\=nK:$\b\"\u0002\b\b\u0001\u0004!\u0016A\u00073fa2|\u00170\\3oiN\u0003Xm\u0019+p\t\u0016\u0004Hn\\=nK:$HC\u0001\u001dk\u0011\u0015q\u0001\u00021\u0001U\u0003q!W\r\u001d7ps6,g\u000e^*qK\u000e$v.\u00168EKBdw._7f]R$\"\u0001O7\t\u000b9I\u0001\u0019\u0001+)\u0005\u0001y\u0007C\u00019x\u001b\u0005\t(B\u0001:t\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0003iV\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002m\u0006\u0019qN]4\n\u0005a\f(aB*feZL7-\u001a\u0015\u0003\u0001i\u00042a_A\u0003\u001b\u0005a(BA?\u007f\u0003)\tgN\\8uCRLwN\u001c\u0006\u0004\u007f\u0006\u0005\u0011a\u00024bGR|'/\u001f\u0006\u0004\u0003\u0007\u0019\u0018!\u00022fC:\u001c\u0018bAA\u0004y\nI\u0011)\u001e;po&\u0014X\r\u001a")
public class DeploymentPreparationService {
    private final DeploymentTaskService deploymentTaskService;
    private final RepositoryService repositoryService;

    private Deployment prepareDeployment(String version, String environment) {
        String applicationId = IdExtensions$.MODULE$.idString(version).getParent();
        if (this.deploymentTaskService.isDeployed(applicationId, environment)) {
            return this.deploymentTaskService.prepareUpdate(version, IdGenerator.generateId((String)environment, (String)IdExtensions$.MODULE$.idString(applicationId).getName()));
        }
        return this.deploymentTaskService.prepareInitial(version, environment);
    }

    public Deployment prepareUnDeployment(DeploymentSpec spec) {
        Deployment deployment = this.deploymentTaskService.prepareUndeploy(spec.version());
        if (deployment == null) {
            throw AsCodeException$.MODULE$.throwDocumentFieldException("Application Version Id", "Application version '" + spec.version() + "' is not deployed in '" + spec.environment() + "'");
        }
        return deployment;
    }

    private void fillInDeployedApplicationFields(Deployment deployment, DeploymentSpec spec) {
        DeployedApplication deployedApplication = (DeployedApplication)deployment.getDeployedApplication();
        spec.deployedApplication().setId(deployedApplication.getId());
        spec.deployedApplication().setVersion(deployedApplication.getVersion());
        spec.deployedApplication().setEnvironment(deployedApplication.getEnvironment());
        deployment.setDeployedApplication((ConfigurationItem)spec.deployedApplication());
    }

    private void readDeployedApplication(Deployment unDeployment, DeploymentSpec spec) {
        DeployedApplication undeployDeployedApplication = (DeployedApplication)unDeployment.getDeployedApplication();
        DeployedApplication deployedApplication = (DeployedApplication)this.repositoryService.read(undeployDeployedApplication.getId(), false);
        undeployDeployedApplication.setDeployeds(deployedApplication.getDeployeds());
        undeployDeployedApplication.setUndeployDependencies(spec.deployedApplication().isUndeployDependencies());
    }

    public Deployment deploymentSpecToDeployment(DeploymentSpec spec) {
        Deployment deployment = this.prepareDeployment(spec.version(), spec.environment());
        Deployment deploymentWithDeployeds = this.deploymentTaskService.prepareAutoDeployeds(deployment);
        this.fillInDeployedApplicationFields(deploymentWithDeployeds, spec);
        return deploymentWithDeployeds;
    }

    public Deployment deploymentSpecToUnDeployment(DeploymentSpec spec) {
        Deployment unDeployment = this.prepareUnDeployment(spec);
        this.readDeployedApplication(unDeployment, spec);
        return unDeployment;
    }

    public DeploymentPreparationService(DeploymentTaskService deploymentTaskService, RepositoryService repositoryService) {
        this.deploymentTaskService = deploymentTaskService;
        this.repositoryService = repositoryService;
    }
}

