package com.xebialabs.deployit.ascode.yaml.parser.util

import com.xebialabs.ascode.yaml.parser.util.IdResolver
import com.xebialabs.deployit.engine.spi.exception.DeployitException

class RelativeIdResolver(definitionKind: String, metadata: Option[Map[String, String]]) extends IdResolver {
  private val containsSlashes = ".*\\/+.*".r
  private val homeRelative = "^\\~(\\w+)\\/(.*)".r
  private val parentRelative = "^([\\.\\.\\/]+)(.*)$".r

  private def getRootHome(root: String): Option[String] = metadata.flatMap(_.get(s"$root-home"))

  override def resolveCiId(name: String,
                           ciType: String,
                           parentId: Option[String]): String = name match {
    case id@containsSlashes() => id
    case _@ciName =>
      val homePath = parentId
        .orElse(getRootHome(definitionKind))
        .getOrElse(definitionKind)
      s"$homePath/$ciName"
  }

  override def resolveReferenceId(name: String,
                                  parentId: Option[String]): String = name match {
        case relativePath@parentRelative(steps, path) =>
          val basePath = parentId.orNull.split('/').dropRight(steps.count(_ == '/')).mkString("/")
          if (basePath.isEmpty) {
            throw new DeployitException("Unable to resolve path [%s]", relativePath)
          }
          s"$basePath/$path"
        case homeRelative(rootName, pathPart) =>
          val homePath = getRootHome(rootName).getOrElse(rootName)
          s"$homePath/$pathPart"
        case id@containsSlashes() => id
        case _@ciName => s"${parentId.orNull}/$ciName"
      }
}
