package com.xebialabs.deployit.ascode.service.spec

import com.xebialabs.ascode.service.spec.{InterpreterContext, SpecInterpreter}
import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.EntityKinds._
import com.xebialabs.ascode.yaml.model.RolesSpec
import com.xebialabs.deployit.core.rest.api.RoleResource
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Autowired
class RolesSpecInterpreter(roleResource: RoleResource) extends SpecInterpreter {
  override def isDefinedAt(context: InterpreterContext): Boolean = context.definition.spec.isInstanceOf[RolesSpec]

  override def apply(context: InterpreterContext): AsCodeResponse = {
    val spec = context.definition.spec.asInstanceOf[RolesSpec]
    AsCodeResponse.ids(spec.roles.foldLeft(ROLE.ids) { (acc, role) =>
      val roleExists = roleResource.exists(role.name)
      roleResource.updatePrincipals(role.name, role.principals.toList.asJava)

      if (roleExists) {
        acc.withUpdated(role.name)
      } else {
        acc.withCreated(role.name)
      }
    })
  }
}
