package com.xebialabs.deployit.ascode.yaml.sugar

import com.xebialabs.ascode.utils.TypeSugar.typeOf
import com.xebialabs.ascode.yaml.sugar.GenerateStrategy.{Filter, Skip}
import com.xebialabs.ascode.yaml.sugar.SugarConfig
import com.xebialabs.ascode.yaml.sugar.SugarConfig._
import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistry, Type}
import com.xebialabs.deployit.plugin.api.udm._
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact
import com.xebialabs.deployit.repository.core.Directory

import scala.jdk.CollectionConverters._

object XLDSugar {
  implicit lazy val defaultConfig: SugarConfig = SugarConfig(
    descriptor[SourceArtifact](blacklistedFields = Set("checksum")),
    descriptor[Directory]("directory"),
    descriptor[EmbeddedDeployedContainer[Deployable, Container]](generateStrategy = Filter({ t: Type =>
      val allTypes = (t :: t.getDescriptor.getInterfaces.asScala.toList) ::: DescriptorRegistry.getSubtypes(t).asScala.toList
      allTypes.contains(typeOf[Container])
    })),
    descriptor[DeployedApplication](generateStrategy = Skip),
  )
}
