package com.xebialabs.deployit.ascode.yaml.parser.util

import com.fasterxml.jackson.databind.JsonNode
import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.parser.support.ReaderConfig
import com.xebialabs.ascode.yaml.parser.util.NodeValidator

import scala.jdk.CollectionConverters._

object CiSpecNodeValidator extends NodeValidator {
  private def isCiRef(fields: List[String]) = fields.length == 1 && fields.contains("ci-ref")

  private def trimName(ciId: Option[String]): Option[String] = ciId match {
    case Some(id) if id.endsWith("/") => None
    case Some(id) =>
      val trimmedName = id.split("/").lastOption.map(_.trim).getOrElse("")
      if (trimmedName.nonEmpty) Some(trimmedName) else None
    case _ => None
  }

  override def validate(config: ReaderConfig, ciId: Option[String], ciType: Option[String], node: JsonNode): Unit = {
    val fields = node.fieldNames().asScala.toList
    if (trimName(ciId).isEmpty && !isCiRef(fields)) {
      throw new AsCodeException("Please make sure that all CI's have non-empty [name] field")
    }
    fields
      .find(_.startsWith("$"))
      .foreach(field => AsCodeException.throwCiFieldValidationException(
        ciId.orNull,
        field,
        s"CI [${ciId.orNull}] has forbidden field [$field]"
      ))
  }
}
