package com.xebialabs.deployit.ascode.service

import java.io.File
import java.util

import com.xebialabs.ascode.service.spec.{InterpreterContext, SpecInterpreter}
import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder
import com.xebialabs.deployit.repository.RepositoryAdapterFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.DependsOn
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
@DependsOn(Array("workdirHolder"))
@Autowired
class DefinitionInterpreterService(factory: RepositoryAdapterFactory, specInterpreters: util.List[SpecInterpreter]) {
  private val handle = SpecInterpreter.compose(specInterpreters.asScala)

  def interpret(context: InterpreterContext): AsCodeResponse = {
    val repository = factory.create(new File(WorkdirHolder.get().getPath))
    CiReferenceResolver.resolve(context.definition.spec, repository)
    handle(context)
  }
}
