/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.model.CiSpec;
import com.xebialabs.ascode.yaml.model.CiSpec$;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.model.Spec;
import com.xebialabs.deployit.ascode.Version$;
import com.xebialabs.deployit.ascode.service.DefinitionGeneratorService$;
import com.xebialabs.deployit.ascode.service.validation.PermissionValidator$;
import com.xebialabs.deployit.core.IdExtensions$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001a<Q!\u0001\u0002\t\u00025\t!\u0004R3gS:LG/[8o\u000f\u0016tWM]1u_J\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000fM,'O^5dK*\u0011QAB\u0001\u0007CN\u001cw\u000eZ3\u000b\u0005\u001dA\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"A\u0007#fM&t\u0017\u000e^5p]\u001e+g.\u001a:bi>\u00148+\u001a:wS\u000e,7CA\b\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\")\u0011d\u0004C\u00015\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\b9=\u0011\r\u0011\"\u0001\u001e\u0003E9UIT#S\u0003R+ulQ%`\u0019&k\u0015\nV\u000b\u0002=A\u00111cH\u0005\u0003AQ\u00111!\u00138u\u0011\u0019\u0011s\u0002)A\u0005=\u0005\u0011r)\u0012(F%\u0006#ViX\"J?2KU*\u0013+!\r\u0011\u0001\"\u0001\u0001\u0013\u0014\u0005\r\u0012\u0002\u0002\u0003\u0014$\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u0015I,\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002)U5\t\u0011F\u0003\u0002'\r%\u00111&\u000b\u0002\u0012%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0007\u0002C\u0017$\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM\u001d\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0019\t\u0001b]3dkJLG/_\u0005\u0003gA\u0012!\u0003U3s[&\u001c8/[8o\u000b:4wN]2fe\")\u0011d\tC\u0001kQ\u0019ag\u000e\u001d\u0011\u00059\u0019\u0003\"\u0002\u00145\u0001\u00049\u0003\"B\u00175\u0001\u0004q\u0003F\u0001\u001b;!\tYd)D\u0001=\u0015\tid(\u0001\u0006b]:|G/\u0019;j_:T!a\u0010!\u0002\u000f\u0019\f7\r^8ss*\u0011\u0011IQ\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u0007\u0012\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u000b\u0006\u0019qN]4\n\u0005\u001dc$!C!vi><\u0018N]3e\u0011\u0015I5\u0005\"\u0003K\u0003!1\u0018\r\\5eCR,GCA&O!\t\u0019B*\u0003\u0002N)\t!QK\\5u\u0011\u0015y\u0005\n1\u0001Q\u0003\u0011\u0019\u0017.\u00133\u0011\u0005ECfB\u0001*W!\t\u0019F#D\u0001U\u0015\t)F\"\u0001\u0004=e>|GOP\u0005\u0003/R\ta\u0001\u0015:fI\u00164\u0017BA-[\u0005\u0019\u0019FO]5oO*\u0011q\u000b\u0006\u0005\u00069\u000e\"\t!X\u0001\tO\u0016tWM]1uKR\u0011a\f\u001d\t\u0004?\u0012<gB\u00011c\u001d\t\u0019\u0016-C\u0001\u0016\u0013\t\u0019G#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00154'\u0001\u0002'jgRT!a\u0019\u000b\u0011\u0005!tW\"A5\u000b\u0005)\\\u0017!B7pI\u0016d'B\u00017n\u0003\u0011I\u0018-\u001c7\u000b\u0005\u0015A\u0011BA8j\u0005)!UMZ5oSRLwN\u001c\u0005\u0006\u001fn\u0003\r\u0001\u0015\u0015\u0003GI\u0004\"a\u001d<\u000e\u0003QT!!\u001e\"\u0002\u0015M$XM]3pif\u0004X-\u0003\u0002xi\n91+\u001a:wS\u000e,\u0007")
public class DefinitionGeneratorService {
    private final RepositoryService repository;
    private final PermissionEnforcer permissionEnforcer;

    public static int GENERATE_CI_LIMIT() {
        return DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT();
    }

    private void validate(String ciId) {
        if (ciId.isEmpty()) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generate path cannot be empty"})).s((Seq)Nil$.MODULE$), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (ciId.startsWith("/")) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot generate definition for path `", "`. It should not start with `/`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ciId})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (!this.repository.exists(ciId)) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A CI with id `", "` does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ciId})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        String string = ciId;
        PermissionValidator$.MODULE$.checkPermissions(PlatformPermissions.READ, (List<String>)Nil$.MODULE$.$colon$colon((Object)string));
    }

    public List<Definition> generate(String ciId) {
        this.validate(ciId);
        SearchParameters params = new SearchParameters();
        params.setAncestor(ciId);
        params.setResultsPerPage((long)(DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT() + 1));
        this.permissionEnforcer.applyLoggedInUserPermission(params, PlatformPermissions.READ);
        List cis = ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.repository.listEntities(params)).toList();
        if (cis.length() > DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT()) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The result contains more then ", " configuration items. Please narrow down the amount of CIs by specifying a more specific path."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT())})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        Definition definition = new Definition(Version$.MODULE$.XLD_API_VERSION(), (Option)None$.MODULE$, IdExtensions$.MODULE$.idString(ciId).getRoot(), (Spec)new CiSpec(cis, CiSpec$.MODULE$.apply$default$2(), CiSpec$.MODULE$.apply$default$3()));
        return Nil$.MODULE$.$colon$colon((Object)definition);
    }

    @Autowired
    public DefinitionGeneratorService(RepositoryService repository, PermissionEnforcer permissionEnforcer) {
        this.repository = repository;
        this.permissionEnforcer = permissionEnforcer;
    }
}

