/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ascode.service.generator;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.deployit.ascode.service.generator.DefinitionGenerator;
import com.xebialabs.deployit.ascode.service.generator.DefinitionGeneratorService$;
import com.xebialabs.deployit.ascode.service.validation.PermissionValidator$;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0001\t\ru!B\u0001\u0003\u0011\u0003y\u0011A\u0007#fM&t\u0017\u000e^5p]\u001e+g.\u001a:bi>\u00148+\u001a:wS\u000e,'BA\u0002\u0005\u0003%9WM\\3sCR|'O\u0003\u0002\u0006\r\u000591/\u001a:wS\u000e,'BA\u0004\t\u0003\u0019\t7oY8eK*\u0011\u0011BC\u0001\tI\u0016\u0004Hn\\=ji*\u00111\u0002D\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!D\u0001\u0004G>l7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u001b\t\u00164\u0017N\\5uS>tw)\u001a8fe\u0006$xN]*feZL7-Z\n\u0003#Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007\"B\u000e\u0012\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u001dq\u0012C1A\u0005\u0002}\t\u0011cR#O\u000bJ\u000bE+R0D\u0013~c\u0015*T%U+\u0005\u0001\u0003CA\u000b\"\u0013\t\u0011cCA\u0002J]RDa\u0001J\t!\u0002\u0013\u0001\u0013AE$F\u001d\u0016\u0013\u0016\tV#`\u0007&{F*S'J)\u00022AAJ\tAO\tyq)\u001a8fe\u0006$xN]\"p]\u001aLwm\u0005\u0003&)!Z\u0003CA\u000b*\u0013\tQcCA\u0004Qe>$Wo\u0019;\u0011\u0005Ua\u0013BA\u0017\u0017\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!ySE!f\u0001\n\u0003\u0001\u0014\u0001B2j\u0013\u0012,\u0012!\r\t\u0004+I\"\u0014BA\u001a\u0017\u0005\u0019y\u0005\u000f^5p]B\u0011Q\u0007\u0010\b\u0003mi\u0002\"a\u000e\f\u000e\u0003aR!!\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\tYd#\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e\u0017\u0011!\u0001UE!E!\u0002\u0013\t\u0014!B2j\u0013\u0012\u0004\u0003\u0002\u0003\"&\u0005+\u0007I\u0011A\"\u0002#\u001ddwNY1m!\u0016\u0014X.[:tS>t7/F\u0001E!\t)R)\u0003\u0002G-\t9!i\\8mK\u0006t\u0007\u0002\u0003%&\u0005#\u0005\u000b\u0011\u0002#\u0002%\u001ddwNY1m!\u0016\u0014X.[:tS>t7\u000f\t\u0005\t\u0015\u0016\u0012)\u001a!C\u0001\u0007\u0006)!o\u001c7fg\"AA*\nB\tB\u0003%A)\u0001\u0004s_2,7\u000f\t\u0005\t\u001d\u0016\u0012)\u001a!C\u0001\u0007\u0006)Qo]3sg\"A\u0001+\nB\tB\u0003%A)\u0001\u0004vg\u0016\u00148\u000f\t\u0005\u00067\u0015\"\tA\u0015\u000b\u0006'V3v\u000b\u0017\t\u0003)\u0016j\u0011!\u0005\u0005\u0006_E\u0003\r!\r\u0005\b\u0005F\u0003\n\u00111\u0001E\u0011\u001dQ\u0015\u000b%AA\u0002\u0011CqAT)\u0011\u0002\u0003\u0007A\tC\u0004[K\u0005\u0005I\u0011A.\u0002\t\r|\u0007/\u001f\u000b\u0006'rkfl\u0018\u0005\b_e\u0003\n\u00111\u00012\u0011\u001d\u0011\u0015\f%AA\u0002\u0011CqAS-\u0011\u0002\u0003\u0007A\tC\u0004O3B\u0005\t\u0019\u0001#\t\u000f\u0005,\u0013\u0013!C\u0001E\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A2+\u0005E\"7&A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017!C;oG\",7m[3e\u0015\tQg#\u0001\u0006b]:|G/\u0019;j_:L!\u0001\\4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004oKE\u0005I\u0011A8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\t\u0001O\u000b\u0002EI\"9!/JI\u0001\n\u0003y\u0017AD2paf$C-\u001a4bk2$He\r\u0005\bi\u0016\n\n\u0011\"\u0001p\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQBqA^\u0013\u0002\u0002\u0013\u0005s/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002qB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0005Y\u0006twMC\u0001~\u0003\u0011Q\u0017M^1\n\u0005uR\b\u0002CA\u0001K\u0005\u0005I\u0011A\u0010\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005\u0015Q%!A\u0005\u0002\u0005\u001d\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0013\ty\u0001E\u0002\u0016\u0003\u0017I1!!\u0004\u0017\u0005\r\te.\u001f\u0005\n\u0003#\t\u0019!!AA\u0002\u0001\n1\u0001\u001f\u00132\u0011%\t)\"JA\u0001\n\u0003\n9\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u0002\u0005\u0004\u0002\u001c\u0005\u0005\u0012\u0011B\u0007\u0003\u0003;Q1!a\b\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\tiB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t9#JA\u0001\n\u0003\tI#\u0001\u0005dC:,\u0015/^1m)\r!\u00151\u0006\u0005\u000b\u0003#\t)#!AA\u0002\u0005%\u0001\"CA\u0018K\u0005\u0005I\u0011IA\u0019\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u0011\t\u0013\u0005UR%!A\u0005B\u0005]\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003aD\u0011\"a\u000f&\u0003\u0003%\t%!\u0010\u0002\r\u0015\fX/\u00197t)\r!\u0015q\b\u0005\u000b\u0003#\tI$!AA\u0002\u0005%q!CA\"#\u0005\u0005\t\u0012AA#\u0003=9UM\\3sCR|'oQ8oM&<\u0007c\u0001+\u0002H\u0019Aa%EA\u0001\u0012\u0003\tIeE\u0003\u0002H\u0005-3\u0006E\u0005\u0002N\u0005M\u0013\u0007\u0012#E'6\u0011\u0011q\n\u0006\u0004\u0003#2\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003+\nyEA\tBEN$(/Y2u\rVt7\r^5p]RBqaGA$\t\u0003\tI\u0006\u0006\u0002\u0002F!Q\u0011QGA$\u0003\u0003%)%a\u000e\t\u0015\u0005}\u0013qIA\u0001\n\u0003\u000b\t'A\u0003baBd\u0017\u0010F\u0005T\u0003G\n)'a\u001a\u0002j!1q&!\u0018A\u0002EB\u0001BQA/!\u0003\u0005\r\u0001\u0012\u0005\t\u0015\u0006u\u0003\u0013!a\u0001\t\"Aa*!\u0018\u0011\u0002\u0003\u0007A\t\u0003\u0006\u0002n\u0005\u001d\u0013\u0011!CA\u0003_\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002r\u0005e\u0004\u0003B\u000b3\u0003g\u0002r!FA;c\u0011#E)C\u0002\u0002xY\u0011a\u0001V;qY\u0016$\u0004\"CA>\u0003W\n\t\u00111\u0001T\u0003\rAH\u0005\r\u0005\n\u0003\u007f\n9%%A\u0005\u0002=\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004\"CAB\u0003\u000f\n\n\u0011\"\u0001p\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011qQA$#\u0003%\ta\\\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u0005-\u0015qII\u0001\n\u0003y\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005=\u0015qII\u0001\n\u0003y\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\u0005M\u0015qII\u0001\n\u0003y\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\t\u0015\u0005]\u0015qIA\u0001\n\u0013\tI*A\u0006sK\u0006$'+Z:pYZ,GCAAN!\rI\u0018QT\u0005\u0004\u0003?S(AB(cU\u0016\u001cGOB\u0003\u0013\u0005\u0001\t\u0019kE\u0002\u0002\"RA1\"a*\u0002\"\n\u0005\t\u0015!\u0003\u0002*\u0006Q!/\u001a9pg&$xN]=\u0011\t\u0005-\u0016qV\u0007\u0003\u0003[S1!a*\t\u0013\u0011\t\t,!,\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW\rC\u0006\u00026\u0006\u0005&\u0011!Q\u0001\n\u0005]\u0016A\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ\u0004B!!/\u0002@6\u0011\u00111\u0018\u0006\u0004\u0003{C\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005\u0005\u00171\u0018\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000fC\u0006\u0002F\u0006\u0005&\u0011!Q\u0001\n\u0005\u001d\u0017AC4f]\u0016\u0014\u0018\r^8sgB1\u0011\u0011ZAh\u0003'l!!a3\u000b\u0007\u00055G0\u0001\u0003vi&d\u0017\u0002BAi\u0003\u0017\u0014A\u0001T5tiB\u0019\u0001#!6\n\u0007\u0005]'AA\nEK\u001aLg.\u001b;j_:<UM\\3sCR|'\u000fC\u0004\u001c\u0003C#\t!a7\u0015\u0011\u0005u\u0017q\\Aq\u0003G\u00042\u0001EAQ\u0011!\t9+!7A\u0002\u0005%\u0006\u0002CA[\u00033\u0004\r!a.\t\u0011\u0005\u0015\u0017\u0011\u001ca\u0001\u0003\u000fD\u0001\"a:\u0002\"\u0012%\u0011\u0011^\u0001\tm\u0006d\u0017\u000eZ1uKR!\u00111^Ay!\r)\u0012Q^\u0005\u0004\u0003_4\"\u0001B+oSRD\u0001\"a=\u0002f\u0002\u0007\u0011Q_\u0001\u0007G>tg-[4\u0011\u0007\u0005]XED\u0002\u0002z\u0002qA!a?\u0003\u00109!\u0011Q B\u0007\u001d\u0011\tyPa\u0003\u000f\t\t\u0005!\u0011\u0002\b\u0005\u0005\u0007\u00119AD\u00028\u0005\u000bI\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A\u0001\u0003\u0005\u0003\u0014\u0005\u0005F\u0011\u0002B\u000b\u0003-\u0011X\r\u001e:jKZ,7)[:\u0015\t\t]!1\b\t\u0007\u00053\u0011\u0019Ca\n\u000f\t\tm!q\u0004\b\u0004o\tu\u0011\"A\f\n\u0007\t\u0005b#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E'Q\u0005\u0006\u0004\u0005C1\u0002\u0003\u0002B\u0015\u0005oi!Aa\u000b\u000b\t\t5\"qF\u0001\u0004k\u0012l'\u0002\u0002B\u0019\u0005g\t1!\u00199j\u0015\r\u0011)\u0004C\u0001\u0007a2,x-\u001b8\n\t\te\"1\u0006\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007\u0002CAz\u0005#\u0001\r!!>\t\u0011\t}\u0012\u0011\u0015C\u0001\u0005\u0003\n\u0001bZ3oKJ\fG/\u001a\u000b\u0005\u0005\u0007\u00129\u0006\u0005\u0004\u0003\u001a\t\r\"Q\t\t\u0005\u0005\u000f\u0012\u0019&\u0004\u0002\u0003J)!!1\nB'\u0003\u0015iw\u000eZ3m\u0015\u0011\u0011yE!\u0015\u0002\te\fW\u000e\u001c\u0006\u0003\u000f)IAA!\u0016\u0003J\tQA)\u001a4j]&$\u0018n\u001c8\t\u0011\u0005M(Q\ba\u0001\u0003kDC!!)\u0003\\A!!Q\fB9\u001b\t\u0011yFC\u0002k\u0005CRAAa\u0019\u0003f\u00059a-Y2u_JL(\u0002\u0002B4\u0005S\nQAY3b]NTAAa\u001b\u0003n\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0003p\u0005\u0019qN]4\n\t\tM$q\f\u0002\n\u0003V$xn^5sK\u0012DC!!)\u0003xA!!\u0011\u0010B@\u001b\t\u0011YH\u0003\u0003\u0003~\t%\u0014AC:uKJ,w\u000e^=qK&!!\u0011\u0011B>\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DefinitionGeneratorService {
    private final RepositoryService repository;
    private final PermissionEnforcer permissionEnforcer;
    private final java.util.List<DefinitionGenerator> generators;

    public static int GENERATE_CI_LIMIT() {
        return DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT();
    }

    private void validate(GeneratorConfig config) {
        if (config.ciId().isEmpty() && !config.globalPermissions() && !config.roles() && !config.users()) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generate path cannot be empty"})).s((Seq)Nil$.MODULE$), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        config.ciId().foreach((Function1 & Serializable & scala.Serializable)ciId -> {
            DefinitionGeneratorService.$anonfun$validate$1(this, ciId);
            return BoxedUnit.UNIT;
        });
    }

    private List<ConfigurationItem> retrieveCis(GeneratorConfig config) {
        return (List)config.ciId().map((Function1 & Serializable & scala.Serializable)ciId -> {
            void var3_3;
            SearchParameters params = new SearchParameters();
            params.setAncestor(ciId);
            params.setResultsPerPage((long)(DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT() + 1));
            $this.permissionEnforcer.applyLoggedInUserPermission(params, PlatformPermissions.READ);
            List cis = ImplicitConversions$.MODULE$.list$u0020asScalaBuffer($this.repository.listEntities(params)).toList();
            if (cis.length() > DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT()) {
                throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The result contains more then ", " configuration items. Please narrow down the amount of CIs by specifying a more specific path."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)DefinitionGeneratorService$.MODULE$.GENERATE_CI_LIMIT())})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            return var3_3;
        }).toList().flatten((Function1)Predef$.MODULE$.$conforms());
    }

    public List<Definition> generate(GeneratorConfig config) {
        this.validate(config);
        List<ConfigurationItem> cis = this.retrieveCis(config);
        return (List)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.generators).toList().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.generate(config, cis), List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$validate$1(DefinitionGeneratorService $this, String ciId) {
        if (ciId.startsWith("/")) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot generate definition for path `", "`. It should not start with `/`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ciId})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (!$this.repository.exists(ciId)) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A CI with id `", "` does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ciId})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        String string = ciId;
        PermissionValidator$.MODULE$.checkPermissions(PlatformPermissions.READ, (List<String>)Nil$.MODULE$.$colon$colon((Object)string));
    }

    public DefinitionGeneratorService(RepositoryService repository, PermissionEnforcer permissionEnforcer, java.util.List<DefinitionGenerator> generators) {
        this.repository = repository;
        this.permissionEnforcer = permissionEnforcer;
        this.generators = generators;
    }

    public static class GeneratorConfig
    implements Product,
    scala.Serializable {
        private final Option<String> ciId;
        private final boolean globalPermissions;
        private final boolean roles;
        private final boolean users;

        public Option<String> ciId() {
            return this.ciId;
        }

        public boolean globalPermissions() {
            return this.globalPermissions;
        }

        public boolean roles() {
            return this.roles;
        }

        public boolean users() {
            return this.users;
        }

        public GeneratorConfig copy(Option<String> ciId, boolean globalPermissions, boolean roles, boolean users) {
            return new GeneratorConfig(ciId, globalPermissions, roles, users);
        }

        public Option<String> copy$default$1() {
            return this.ciId();
        }

        public boolean copy$default$2() {
            return this.globalPermissions();
        }

        public boolean copy$default$3() {
            return this.roles();
        }

        public boolean copy$default$4() {
            return this.users();
        }

        public String productPrefix() {
            return "GeneratorConfig";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.ciId();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.globalPermissions());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.roles());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.users());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof GeneratorConfig;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.ciId()));
            n = Statics.mix((int)n, (int)(this.globalPermissions() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.roles() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.users() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof GeneratorConfig)) return false;
            boolean bl = true;
            if (!bl) return false;
            GeneratorConfig generatorConfig = (GeneratorConfig)x$1;
            Option<String> option = this.ciId();
            Option<String> option2 = generatorConfig.ciId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.globalPermissions() != generatorConfig.globalPermissions()) return false;
            if (this.roles() != generatorConfig.roles()) return false;
            if (this.users() != generatorConfig.users()) return false;
            if (!generatorConfig.canEqual(this)) return false;
            return true;
        }

        public GeneratorConfig(Option<String> ciId, boolean globalPermissions, boolean roles, boolean users) {
            this.ciId = ciId;
            this.globalPermissions = globalPermissions;
            this.roles = roles;
            this.users = users;
            Product.$init$((Product)this);
        }
    }
}

