/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.ascode.yaml.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.Specs;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.parser.DefinitionParser$;
import com.xebialabs.ascode.yaml.parser.SpecParser;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005-t!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0005#fM&t\u0017\u000e^5p]B\u000b'o]3s\u0015\t\u0019A!\u0001\u0004qCJ\u001cXM\u001d\u0006\u0003\u000b\u0019\tA!_1nY*\u0011q\u0001C\u0001\u0007CN\u001cw\u000eZ3\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"\u0001\u0005#fM&t\u0017\u000e^5p]B\u000b'o]3s'\ty!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\u00063=!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035AQ\u0001H\b\u0005\u0002u\tQ!\u00199qYf$RAHA)\u0003+\u0002\"AD\u0010\u0007\tA\u0011\u0001\u0001I\n\u0003?IA\u0001BI\u0010\u0003\u0002\u0003\u0006IaI\u0001\u0006gB,7m\u001d\t\u0004I\u0015:S\"\u0001\u0003\n\u0005\u0019\"!!B*qK\u000e\u001c\bC\u0001\b)\u0013\tI#A\u0001\u0006Ta\u0016\u001c\u0007+\u0019:tKJDQ!G\u0010\u0005\u0002-\"\"A\b\u0017\t\u000b\tR\u0003\u0019A\u0012\t\u000f9z\"\u0019!C\u0005_\u00059a-Y2u_JLX#\u0001\u0019\u0011\u0005EJT\"\u0001\u001a\u000b\u0005\u0015\u0019$B\u0001\u001b6\u0003)!\u0017\r^1g_Jl\u0017\r\u001e\u0006\u0003m]\nqA[1dWN|gN\u0003\u00029\u0015\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003uI\u00121\"W!N\u0019\u001a\u000b7\r^8ss\"1Ah\bQ\u0001\nA\n\u0001BZ1di>\u0014\u0018\u0010\t\u0005\b}}\u0011\r\u0011b\u0003@\u0003\u0019i\u0017\r\u001d9feV\t\u0001\t\u0005\u0002B\t6\t!I\u0003\u0002Dk\u0005AA-\u0019;bE&tG-\u0003\u0002F\u0005\naqJ\u00196fGRl\u0015\r\u001d9fe\"1qi\bQ\u0001\n\u0001\u000bq!\\1qa\u0016\u0014\b\u0005C\u0003J?\u0011\u0005!*\u0001\twC2LG-\u0019;f\u001b\u0016$\u0018\rZ1uCR\u00111J\u0014\t\u0003'1K!!\u0014\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001f\"\u0003\r\u0001U\u0001\t[\u0016$\u0018\rZ1uCB!\u0011\u000bW.\\\u001d\t\u0011f\u000b\u0005\u0002T)5\tAK\u0003\u0002V\u0019\u00051AH]8pizJ!a\u0016\u000b\u0002\rA\u0013X\rZ3g\u0013\tI&LA\u0002NCBT!a\u0016\u000b\u0011\u0005Ec\u0016BA/[\u0005\u0019\u0019FO]5oO\")ql\bC\u0005A\u0006y\u0001/\u0019:tK\u0012+g-\u001b8ji&|g\u000e\u0006\u0002bOB\u0011!-Z\u0007\u0002G*\u0011A\rB\u0001\u0006[>$W\r\\\u0005\u0003M\u000e\u0014!\u0002R3gS:LG/[8o\u0011\u0015Ag\f1\u0001j\u0003\u0011qw\u000eZ3\u0011\u0005)dW\"A6\u000b\u0005!\u0014\u0015BA7l\u0005)y%M[3di:{G-\u001a\u0005\u0006_~!I\u0001]\u0001\fO\u0016$X*\u001a;bI\u0006$\u0018\rF\u0002r\u0003\u000b\u00012a\u0005:u\u0013\t\u0019HC\u0001\u0004PaRLwN\u001c\t\u0005kj\\80D\u0001w\u0015\t9\b0A\u0005j[6,H/\u00192mK*\u0011\u0011\u0010F\u0001\u000bG>dG.Z2uS>t\u0017BA-w!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0005!!.\u0019<b\u0013\tiV\u0010C\u0003i]\u0002\u0007\u0011\u000eC\u0004\u0002\n}!\t!a\u0003\u00021\u001d,G\u000fU1sg\u0016,\u0005pY3qi&|g.T3tg\u0006<W\rF\u0002\\\u0003\u001bA\u0001\"a\u0004\u0002\b\u0001\u0007\u0011\u0011C\u0001\u0002KB!\u00111CA\u000f\u001d\u0011\t)\"!\u0007\u000f\u0007M\u000b9\"C\u0001\u0016\u0013\r\tY\u0002F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty\"!\t\u0003\u0013QC'o\\<bE2,'bAA\u000e)!9\u0011QE\u0010\u0005\n\u0005\u001d\u0012!\u00039beN,\u0017,Y7m)\r\t\u0017\u0011\u0006\u0005\t\u0003W\t\u0019\u00031\u0001\u0002.\u0005Q\u00110Y7m!\u0006\u00148/\u001a:\u0011\u0007E\ny#C\u0002\u00022I\u0012!\"W!N\u0019B\u000b'o]3s\u0011\u001d\t)d\bC\u0001\u0003o\tQ\u0001]1sg\u0016$2!YA\u001d\u0011!\tY$a\rA\u0002\u0005u\u0012AB:ue\u0016\fW\u000e\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019e`\u0001\u0003S>LA!a\u0012\u0002B\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\t)d\bC\u0001\u0003\u0017\"2!YA'\u0011\u001d\ty%!\u0013A\u0002m\u000baa\u001d;sS:<\u0007BBA*7\u0001\u00071,A\u0004qe>$Wo\u0019;\t\u000f\u0005]3\u00041\u0001\u0002Z\u0005Y1\u000f]3d!\u0006\u00148/\u001a:t!\u0015\u0019\u00121LA0\u0013\r\ti\u0006\u0006\u0002\u000byI,\u0007/Z1uK\u0012t\u0004CB\n\u0002b\u0005\u0015t%C\u0002\u0002dQ\u0011a\u0001V;qY\u0016\u0014\u0004#BA\n\u0003OZ\u0016\u0002BA5\u0003C\u0011A\u0001T5ti\u0002")
public class DefinitionParser {
    private final Specs<SpecParser> specs;
    private final YAMLFactory factory;
    private final ObjectMapper mapper;

    public static DefinitionParser apply(String string, Seq<Tuple2<List<String>, SpecParser>> seq) {
        return DefinitionParser$.MODULE$.apply(string, seq);
    }

    private YAMLFactory factory() {
        return this.factory;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public void validateMetadata(Map<String, String> metadata) {
        Set validHomes = (Set)((SetLike)this.specs.specs().keySet().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String kind = (String)tuple2._2();
            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-home"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kind}));
            return string;
        }, Set$.MODULE$.canBuildFrom())).$plus((Object)"home");
        metadata.keys().foreach((Function1 & Serializable & scala.Serializable)metadataHome -> {
            DefinitionParser.$anonfun$validateMetadata$2(validHomes, metadataHome);
            return BoxedUnit.UNIT;
        });
    }

    private Definition parseDefinition(ObjectNode node) {
        if (!node.has("apiVersion") || node.get("apiVersion").isNull()) {
            throw new AsCodeException("Document is missing an apiVersion definition", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        String apiVersion = node.get("apiVersion").asText();
        if (apiVersion.isEmpty() || apiVersion.indexOf(47) == -1) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"apiVersion format invalid: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)apiVersion).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        String project = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(apiVersion)).split('/'))).head();
        if (!node.has("kind") || node.get("kind").isNull()) {
            throw new AsCodeException("Document is missing a kind definition", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        String kind = node.get("kind").asText();
        SpecParser specParser = this.specs.getSpec(project, kind);
        Option<Map<String, String>> metadata2 = this.getMetadata(node);
        metadata2.foreach((Function1 & Serializable & scala.Serializable)metadata -> {
            this.validateMetadata((Map<String, String>)metadata);
            return BoxedUnit.UNIT;
        });
        if (!node.has("spec") || node.get("spec").isNull()) {
            throw new AsCodeException("Document is missing a spec definition", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return new Definition(apiVersion, metadata2, kind, specParser.parse(kind, metadata2, node.get("spec"), this.mapper()));
    }

    private Option<Map<String, String>> getMetadata(ObjectNode node) {
        return Option$.MODULE$.apply((Object)node.get("metadata")).map((Function1 & Serializable & scala.Serializable)x$1 -> ImplicitConversions$.MODULE$.iterator$u0020asScala(x$1.fields()).map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(field.getKey()), (Object)((JsonNode)field.getValue()).asText(null))).toMap(Predef$.MODULE$.$conforms()));
    }

    public String getParseExceptionMessage(Throwable e) {
        String string;
        Throwable throwable = e;
        if (throwable instanceof JsonParseException) {
            JsonParseException jsonParseException = (JsonParseException)throwable;
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " at line number: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jsonParseException.getOriginalMessage(), BoxesRunTime.boxToInteger((int)jsonParseException.getLocation().getLineNr())}));
        } else {
            string = throwable.getCause() != null ? this.getParseExceptionMessage(throwable.getCause()) : throwable.getMessage();
        }
        return string;
    }

    private Definition parseYaml(YAMLParser yamlParser) {
        ObjectNode document;
        block6: {
            Try try_;
            boolean bl;
            block5: {
                bl = false;
                Success success = null;
                try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ImplicitConversions$.MODULE$.iterator$u0020asScala(yamlParser.readValuesAs(ObjectNode.class)).toList());
                if (!(try_ instanceof Success)) break block5;
                bl = true;
                success = (Success)try_;
                List list = (List)success.value();
                if (!(list instanceof .colon.colon)) break block5;
                .colon.colon colon2 = (.colon.colon)list;
                document = (ObjectNode)colon2.head();
                List list2 = colon2.tl$access$1();
                if (Nil$.MODULE$.equals(list2)) break block6;
            }
            if (bl) {
                throw new AsCodeException("This endpoint handles only one document per request.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new AsCodeException(this.getParseExceptionMessage(e), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError((Object)try_);
        }
        Definition definition = this.parseDefinition(document);
        return definition;
    }

    public Definition parse(InputStream stream) {
        return this.parseYaml(this.factory().createParser(stream));
    }

    public Definition parse(String string) {
        return this.parseYaml(this.factory().createParser(string));
    }

    public static final /* synthetic */ void $anonfun$validateMetadata$2(Set validHomes$1, String metadataHome) {
        if (!validHomes$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)metadataHome.equals(x$1)))) {
            throw new AsCodeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid home defined: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadataHome})), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public DefinitionParser(Specs<SpecParser> specs) {
        this.specs = specs;
        this.factory = new YAMLFactory();
        this.factory().enable(JsonParser.Feature.STRICT_DUPLICATE_DETECTION);
        this.mapper = new ObjectMapper((JsonFactory)this.factory());
    }
}

