/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.tasks;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.xebialabs.deployit.ci.bamboo.util.BambooDeploymentListener;
import com.xebialabs.deployit.client.ConnectionOptions;
import com.xebialabs.deployit.client.DeployitCli;
import com.xebialabs.deployit.client.DeploymentListener;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDeployitTask
implements TaskType {
    protected final ErrorUpdateHandler errorUpdateHandler;

    public AbstractDeployitTask(ErrorUpdateHandler errorUpdateHandler) {
        this.errorUpdateHandler = errorUpdateHandler;
    }

    abstract void doExecute(TaskContext var1, DeployitCli var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.create((TaskContext)taskContext);
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        String username = (String)configurationMap.get((Object)"deployitUsername");
        String password = (String)configurationMap.get((Object)"deployitPassword");
        String serverUrl = (String)configurationMap.get((Object)"deployitServerUrl");
        ConnectionOptions options = new ConnectionOptions(serverUrl, username, password);
        Thread currentThread = Thread.currentThread();
        ClassLoader origClassLoader = currentThread.getContextClassLoader();
        ClassLoader taskClassLoader = DeployitCli.class.getClassLoader();
        try {
            currentThread.setContextClassLoader(taskClassLoader);
            DeployitCli cli = new DeployitCli(options, (DeploymentListener)new BambooDeploymentListener(taskContext.getBuildLogger()));
            this.doExecute(taskContext, cli);
            taskResultBuilder.success();
        }
        catch (Exception e) {
            PlanResultKey planResultKey = taskContext.getBuildContext().getPlanResultKey();
            this.errorUpdateHandler.recordError(planResultKey, e.getMessage(), (Throwable)e);
            taskResultBuilder.failedWithError();
        }
        finally {
            currentThread.setContextClassLoader(origClassLoader);
        }
        return taskResultBuilder.build();
    }
}

