/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.tasks;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.ci.bamboo.client.DeployitException;
import com.xebialabs.deployit.ci.bamboo.util.RemoteBooterConfigurer;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeployitTask
implements TaskType {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDeployitTask.class);
    private static boolean booterConfigured = false;
    protected final ErrorUpdateHandler errorUpdateHandler;
    private DeployitCommunicator communicator;

    public AbstractDeployitTask(ErrorUpdateHandler errorUpdateHandler) {
        this.errorUpdateHandler = errorUpdateHandler;
    }

    abstract void doExecute(TaskContext var1, DeployitCommunicator var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(TaskContext taskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.create((TaskContext)taskContext);
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        String username = (String)configurationMap.get((Object)"deployitUsername");
        String password = (String)configurationMap.get((Object)"deployitPassword");
        String serverUrl = (String)configurationMap.get((Object)"deployitServerUrl");
        Thread currentThread = Thread.currentThread();
        ClassLoader origClassLoader = currentThread.getContextClassLoader();
        ClassLoader taskClassLoader = DeployitCommunicator.class.getClassLoader();
        try {
            LOGGER.debug("Setting context classloader: {}", (Object)taskClassLoader);
            currentThread.setContextClassLoader(taskClassLoader);
            this.doExecute(taskContext, this.boot(serverUrl, username, password));
            taskResultBuilder.success();
        }
        catch (Exception e) {
            PlanResultKey planResultKey = taskContext.getBuildContext().getPlanResultKey();
            this.errorUpdateHandler.recordError(planResultKey, e.getMessage(), (Throwable)e);
            taskResultBuilder.failedWithError();
        }
        finally {
            LOGGER.debug("Restoring context classloader: {}", (Object)origClassLoader);
            currentThread.setContextClassLoader(origClassLoader);
        }
        return taskResultBuilder.build();
    }

    protected DeployitCommunicator boot(String serverUrl, String username, String password) throws MalformedURLException {
        BooterConfig config;
        URL server = new URL(serverUrl);
        if (!booterConfigured) {
            RemoteBooterConfigurer.preconfigure();
            booterConfigured = true;
        }
        int port = server.getPort();
        try {
            config = BooterConfig.builder().withProtocol(BooterConfig.Protocol.valueOf((String)server.getProtocol().toUpperCase())).withCredentials(username, password).withHost(server.getHost()).withPort(port == -1 ? server.getDefaultPort() : port).withContext(server.getPath()).build();
        }
        catch (IllegalArgumentException e) {
            throw new DeployitException(String.format("Error while trying to deployit with server URL: %s", serverUrl));
        }
        return RemoteBooter.boot((BooterConfig)config);
    }
}

