/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Strings;
import com.xebialabs.deployit.ci.DeployableView;
import com.xebialabs.deployit.ci.DeployableViewDescriptor;
import com.xebialabs.deployit.ci.Messages;
import com.xebialabs.deployit.ci.NameValuePair;
import com.xebialabs.deployit.ci.util.DeployitTypes;
import com.xebialabs.deployit.ci.util.FileFinder;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import com.xebialabs.deployit.ci.util.ListBoxModels;
import com.xebialabs.deployit.client.Deployable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.util.IOException2;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactView
extends DeployableView {
    public String location;

    @DataBoundConstructor
    public ArtifactView(String type, String name, String location, String tags, List<NameValuePair> properties) {
        super(type, name, tags, properties);
        this.location = location;
    }

    @Override
    public Deployable newDeployable(DeployitTypes deployitTypes, FilePath workspace, EnvVars envVars, JenkinsDeploymentListener listener) {
        try {
            Deployable deployable = super.newDeployable(deployitTypes, workspace, envVars, listener);
            File file = this.fromPattern(workspace, listener);
            deployable.setLocation(file);
            return deployable;
        }
        catch (Exception e) {
            throw new RuntimeException("setLocation failed on deployable " + this.getName(), e);
        }
    }

    private File fromPattern(FilePath workspace, JenkinsDeploymentListener listener) throws IOException, InterruptedException {
        if (Strings.emptyToNull((String)this.location) == null) {
            throw new RuntimeException("location of " + this.getName() + " of " + this.getType() + " is empty");
        }
        listener.info(String.format("search %s from %s", this.location, workspace));
        FileFinder fileFinder = new FileFinder(this.location);
        List fileNames = (List)workspace.act((FilePath.FileCallable)fileFinder);
        listener.info(" found remote files : " + fileNames);
        if (fileNames.size() > 1) {
            Localizable localizable = Messages._DeployitNotifier_TooManyFilesMatchingPattern();
            listener.error(localizable);
            throw new RuntimeException(String.valueOf(localizable));
        }
        if (fileNames.size() == 0) {
            Localizable localizable = Messages._DeployitNotifier_noArtifactsFound(this.location);
            listener.error(localizable);
            throw new RuntimeException(String.valueOf(localizable));
        }
        String artifactPath = (String)fileNames.get(0);
        return this.fetchFile(artifactPath, workspace);
    }

    private File fetchFile(String artifactPath, FilePath workspace) throws IOException2 {
        if (new File(artifactPath).isAbsolute()) {
            return new File(artifactPath);
        }
        return new File(workspace.getRemote(), artifactPath);
    }

    @Extension
    public static final class DescriptorImpl
    extends DeployableViewDescriptor {
        public String getDisplayName() {
            return "Artifact";
        }

        public ListBoxModel doFillTypeItems() {
            return ListBoxModels.of(this.getDeployitDescriptor().getAllArtifactTypes());
        }
    }
}

