/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.ci.NameValuePair;
import com.xebialabs.deployit.ci.util.DeployitTypes;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import com.xebialabs.deployit.ci.util.Strings2;
import com.xebialabs.deployit.client.Deployable;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployableView
implements Describable<DeployableView> {
    public String type;
    public String name;
    public String tags;
    public List<NameValuePair> properties;

    protected DeployableView(String type, String name, String tags, List<NameValuePair> properties) {
        this.type = type;
        this.name = name;
        this.tags = tags;
        this.properties = properties;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Deployable newDeployable(DeployitTypes deployitTypes, FilePath workspace, EnvVars envVars, JenkinsDeploymentListener listener) {
        Deployable deployable = new Deployable(this.name, this.type);
        if (!Strings.isNullOrEmpty((String)this.tags)) {
            deployable.getTags().addAll(Strings2.commaSeparatedListToList(this.tags));
        }
        deployable.getValues().putAll(this.getMapOfProperties(deployitTypes.getPropertyDescriptors(this.type), envVars));
        return deployable;
    }

    public Descriptor<DeployableView> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    private Map<String, String> getMapOfProperties(Collection<PropertyDescriptor> propertyDescriptors, EnvVars envVars) {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NameValuePair pair : this.properties) {
            String value = Strings2.stripEnclosingQuotes(Strings.nullToEmpty((String)pair.propertyValue));
            DeployableView.addManifestEntries((ImmutableMap.Builder<String, String>)builder, DeployableView.getPropertyDescriptor(propertyDescriptors, pair.propertyName), pair.propertyName, envVars.expand(value));
        }
        return builder.build();
    }

    private static PropertyDescriptor getPropertyDescriptor(Collection<PropertyDescriptor> propertyDescriptors, final String propertyName) {
        return (PropertyDescriptor)Iterables.find(propertyDescriptors, (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return Objects.equal((Object)input.getName(), (Object)propertyName);
            }
        });
    }

    private static void addManifestEntries(ImmutableMap.Builder<String, String> entries, PropertyDescriptor propertyDescriptor, String propertyName, String value) {
        if (propertyDescriptor.isHidden()) {
            return;
        }
        if (value == null) {
            return;
        }
        switch (propertyDescriptor.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case STRING: 
            case ENUM: {
                entries.put((Object)("CI-" + propertyName), (Object)value);
                break;
            }
            case CI: {
                entries.put((Object)("CI-" + propertyName), (Object)value);
                break;
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: 
            case SET_OF_CI: 
            case LIST_OF_CI: {
                int entryCount = 1;
                for (String entry : Strings2.commaSeparatedListToList(value)) {
                    String attributeName = "CI-" + propertyName + "-EntryValue-" + entryCount++;
                    entries.put((Object)attributeName, (Object)entry);
                }
                break;
            }
            case MAP_STRING_STRING: {
                for (Map.Entry<String, String> entry : Strings2.uriQueryStringToMap(value).entrySet()) {
                    String attributeName = "CI-" + propertyName + "-" + entry.getKey();
                    entries.put((Object)attributeName, (Object)entry.getValue());
                }
                break;
            }
        }
    }
}

