/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.ci.ArtifactView;
import com.xebialabs.deployit.ci.ImportLocation;
import com.xebialabs.deployit.ci.ImportLocationDescriptor;
import com.xebialabs.deployit.ci.util.JenkinsDeploymentListener;
import hudson.Extension;
import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class FileSystemLocation
extends ImportLocation {
    public final String location;
    public final String workingDirectory;

    @DataBoundConstructor
    public FileSystemLocation(String location, String workingDirectory) {
        this.location = location;
        this.workingDirectory = workingDirectory;
    }

    public String getDarFileLocation(FilePath workspace, JenkinsDeploymentListener deploymentListener) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)this.location), (Object)"location is empty or null");
        FilePath root = Strings.isNullOrEmpty((String)this.workingDirectory) ? workspace : new FilePath(new File(this.workingDirectory));
        try {
            return ArtifactView.findFileFromPattern(this.location, root, deploymentListener).getPath();
        }
        catch (IOException exception) {
            throw new RuntimeException(String.format("Unable to find DAR from %s in %s", this.location, root), exception);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ImportLocationDescriptor {
        public String getDisplayName() {
            return "FileSystem";
        }
    }
}

