/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.api.internal.ImportHelper;
import com.xebialabs.deployit.cli.api.internal.PrintHelper;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.api.dto.ConfigurationItem;
import com.xebialabs.deployit.core.api.dto.ImportablePackages;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.dto.ServerInfo;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@CliObject(name="deployit")
@ClassHelp(description="The main gateway to interfacing with Deployit.")
public class DeployitClient
extends DocumentedObject {
    private final Proxies proxies;

    public DeployitClient() {
        this.proxies = null;
    }

    public DeployitClient(Proxies proxies) {
        this.proxies = proxies;
    }

    @MethodHelp(description="Import a package located on the server or local file system.", parameters={@ParameterHelp(name="importablePackage", description="This is either:\n\t- The name of the importable package on the server\n\t- The absolute path to a local importable package.")})
    public RepositoryObject importPackage(String importablePackageName) {
        return ImportHelper.doImport(this.proxies.getImportablePackage(), importablePackageName);
    }

    public List<String> listImportablePackages() {
        return ((ImportablePackages)new ResponseExtractor(this.proxies.getImportablePackage().list()).getEntity()).getFiles();
    }

    @MethodHelp(description="Deploy or upgrade a deployment-package on the targeted environment using the mappings specified, and wait for it to be completed.", parameters={@ParameterHelp(name="source", description="The source deployment-package that is to be deployed"), @ParameterHelp(name="target", description="Can either be:\n\t- The target environment to which you want to deploy\n\t- The existing deployment that needs to be upgraded"), @ParameterHelp(name="mappings", description="The mappings to use for the deployment, if no mappings are specified, default mappings will be used.")}, returns="The id of the task that was executed")
    public String deployAndWait(String source, String target, RepositoryObject ... mappings) {
        String taskId = this.prepareDeployment(source, target, mappings);
        this.startTaskAndWait(taskId);
        return taskId;
    }

    @MethodHelp(description="Deploy or upgrade a deployment-package on the targeted environment using default mappings, and wait for it to be completed.", parameters={@ParameterHelp(name="source", description="The source deployment-package that is to be deployed"), @ParameterHelp(name="target", description="Can either be:\n\t- The target environment to which you want to deploy\n\t- The existing deployment that needs to be upgraded")}, returns="The id of the task that was executed")
    public String deployAndWait(String source, String target) {
        String taskId = this.prepareDeployment(source, target);
        this.startTaskAndWait(taskId);
        return taskId;
    }

    public void startTaskAndWait(String taskId) {
        this.startTask(taskId);
        boolean done = false;
        TaskInfo ti = null;
        while (!done) {
            ti = (TaskInfo)new ResponseExtractor(this.proxies.getTaskRegistry().getTaskInfo(taskId)).getEntity();
            String st = ti.getState();
            if ("DONE".equals(st) || "ABORTED".equals(st) || "STOPPED".equals(st)) {
                done = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @MethodHelp(description="Deploy or upgrade a deployment-package on the targeted environment using the mappings specified and return immediately.", parameters={@ParameterHelp(name="source", description="The source deployment-package that is to be deployed"), @ParameterHelp(name="target", description="Can either be:\n\t- The target environment to which you want to deploy\n\t- The existing deployment that needs to be upgraded"), @ParameterHelp(name="mappings", description="The mappings to use for the deployment, if no mappings are specified, default mappings will be used.")}, returns="The id of the task that was started")
    public String deploy(String source, String target, RepositoryObject[] mappings) {
        String taskid = this.prepareDeployment(source, target, mappings);
        this.startTask(taskid);
        return taskid;
    }

    @MethodHelp(description="Deploy or upgrade a deployment-package on the targeted environment using default mappings and return immediately.", parameters={@ParameterHelp(name="source", description="The source deployment-package that is to be deployed"), @ParameterHelp(name="target", description="Can either be:\n\t- The target environment to which you want to deploy\n\t- The existing deployment that needs to be upgraded")}, returns="The id of the task that was started")
    public String deploy(String source, String target) {
        String taskid = this.prepareDeployment(source, target);
        this.startTask(taskid);
        return taskid;
    }

    @MethodHelp(description="Generate default mappings.", parameters={@ParameterHelp(name="sources", description="The list of a package member ids"), @ParameterHelp(name="target", description="The target environment id to which you want to deploy")}, returns="The ids of the generated default mappings")
    public RepositoryObject[] generateMappings(List<String> sources, String target) {
        RepositoryObjects mappings = (RepositoryObjects)new ResponseExtractor(this.proxies.getDeployment().generatePartialMappings(sources, target, null)).getEntity();
        return mappings.getObjects().toArray(new RepositoryObject[mappings.getObjects().size()]);
    }

    @MethodHelp(description="Generate default mappings.", parameters={@ParameterHelp(name="sources", description="The list of a package member ids"), @ParameterHelp(name="target", description="The target environment member id to which you want to deploy"), @ParameterHelp(name="mappingType", description="The mapping type to be used for creating the default mappings")}, returns="The ids of the generated default mappings")
    public RepositoryObject[] generateMappings(List<String> sources, String target, String mappingType) {
        RepositoryObjects mappings = (RepositoryObjects)new ResponseExtractor(this.proxies.getDeployment().generatePartialMappings(sources, target, mappingType)).getEntity();
        return mappings.getObjects().toArray(new RepositoryObject[mappings.getObjects().size()]);
    }

    @MethodHelp(description="Prepare Deployment or upgrade of a deployment-package on the targeted environment using default mappings and returns the taskid.", parameters={@ParameterHelp(name="source", description="The source deployment-package that is to be deployed"), @ParameterHelp(name="target", description="Can either be:\n\t- The target environment to which you want to deploy\n\t- The existing deployment that needs to be upgraded")}, returns="The id of the task that was prepared")
    public String prepareDeployment(String source, String target) {
        RepositoryObjects mappingsDto = (RepositoryObjects)new ResponseExtractor(this.proxies.getDeployment().generateMappings(source, target)).getEntity();
        List mappings = mappingsDto.getObjects();
        return this.prepareDeployment(source, target, mappings.toArray(new RepositoryObject[mappings.size()]));
    }

    @MethodHelp(description="Prepare a (un)deployment or upgrade of a deployment-package on the targeted environment using the mappings specified and returns the taskid.", parameters={@ParameterHelp(name="source", description="The source deployment-package that is to be deployed"), @ParameterHelp(name="target", description="Can either be:\n\t- The target environment to which you want to deploy\n\t- The existing deployment that needs to be upgraded"), @ParameterHelp(name="mappings", description="The mappings to use for the deployment")}, returns="The id of the task that was prepared")
    public String prepareDeployment(String source, String target, RepositoryObject[] mappings) {
        ResponseExtractor responseExtractor;
        RepositoryObjects mappingsDto = new RepositoryObjects();
        if (mappings != null && mappings.length > 0) {
            mappingsDto.setObjects(Arrays.asList(mappings));
        }
        if ((responseExtractor = new ResponseExtractor(this.proxies.getDeployment().validate(source, target, mappingsDto))).isValidResponse()) {
            Steps steps = (Steps)new ResponseExtractor(this.proxies.getDeployment().prepare(source, target, mappingsDto)).getEntity();
            return steps.getTaskId();
        }
        RepositoryObjects validated = (RepositoryObjects)responseExtractor.getEntity();
        for (RepositoryObject v : validated.getObjects()) {
            if (v.getValidations().isEmpty()) continue;
            System.out.println(String.format("mapping with id %s has the following validation errors %s", v.getId(), v.getValidations()));
        }
        return null;
    }

    @MethodHelp(description="Retrieve the task information for a (running) deployment task.", parameters={@ParameterHelp(name="taskId", description="The id of the task.")}, returns="The metadata associated with the task")
    public TaskInfo retrieveTaskInfo(String taskId) {
        return (TaskInfo)new ResponseExtractor(this.proxies.getTaskRegistry().getTaskInfo(taskId)).getEntity();
    }

    @MethodHelp(description="Gracefully stop an active deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void stopTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().stop(taskId));
    }

    @MethodHelp(description="Start a deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void startTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().start(taskId));
    }

    @MethodHelp(description="Abort an active deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void abortTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().abort(taskId));
    }

    @MethodHelp(description="Cancel a stopped deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void cancelTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().cancel(taskId));
    }

    @MethodHelp(description="(Un)skip steps of the task.\n- If a step is in the PENDING or FAILED state, it will be SKIPPED.\n- If a step is in the SKIPPED state it will be PENDING. ", parameters={@ParameterHelp(name="taskId", description="The id of the task"), @ParameterHelp(name="stepIds", description="The ids of the steps to skip or unskip")})
    public void skipSteps(String taskId, Integer[] stepIds) {
        String ids = StringUtils.join((Object[])stepIds, (String)",");
        new ResponseExtractor(this.proxies.getTaskRegistry().toggleSkipSteps(taskId, ids));
    }

    @MethodHelp(description="Do a reality check on the middleware specified by the id. The updated values are returned and should be manually stored.", parameters={@ParameterHelp(name="id", description="The id of the discoverable middleware component")}, returns="The updated (but not persisted) repository object.")
    public RepositoryObject realityCheck(String id) {
        return (RepositoryObject)new ResponseExtractor(this.proxies.getDiscovery().realityCheck(id)).getEntity();
    }

    @MethodHelp(description="Discovers middleware associated with the specified discoverable configuration item. Refer to plugin configuration item documentation to see which fields are required for discover.", parameters={@ParameterHelp(name="ci", description="The configuration item with all required discovery fields filled in")}, returns="RepositoryObjects containing all discovered middleware associated with the specified discoverable ci")
    public RepositoryObjects discover(ConfigurationItem ci) {
        return (RepositoryObjects)new ResponseExtractor(this.proxies.getDiscovery().discover(ci)).getEntity();
    }

    @MethodHelp(description="Describe the CI class, with all the values it takes.", parameters={@ParameterHelp(name="shortName", description="The (Short) name of the CI eg. \"Host\", \"WasDataSource\", etc")})
    public void describe(String typeName) {
        DescriptorHelper.describe(typeName);
    }

    @MethodHelp(description="Print a tree-view of a CI", parameters={@ParameterHelp(name="ci", description="The CI to print")})
    public void print(RepositoryObject ci) {
        PrintHelper.printCi(ci, this.proxies);
    }

    public Comparison compare(String reference, List<String> ids) {
        return (Comparison)new ResponseExtractor(this.proxies.getQuery().compare(reference, ids)).getEntity();
    }

    public ServerInfo info() {
        return (ServerInfo)new ResponseExtractor(this.proxies.getServer().getInfo()).getEntity();
    }
}

