/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.ImportablePackageProxy;
import com.xebialabs.deployit.core.api.dto.FileUpload;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import java.io.File;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHelper {
    private static final Logger logger = LoggerFactory.getLogger(ImportHelper.class);

    public static RepositoryObject doImport(ImportablePackageProxy proxy, String packageToImport) {
        Response response;
        File file = new File(packageToImport);
        if (file.exists()) {
            FileUpload fileUpload = new FileUpload();
            try {
                fileUpload.setFileData(FileUtils.readFileToByteArray((File)file));
                response = proxy.importUploadedPackage(fileUpload);
            }
            catch (IOException e) {
                logger.error("The file {} exists, but could not be read for upload.");
                return null;
            }
        } else {
            response = proxy.importPackage(packageToImport);
        }
        return (RepositoryObject)new ResponseExtractor(response).getEntity();
    }
}

