/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StopOptionHandler;

public class CliOptions {
    static final int DEFAULT_DEPLOYIT_SERVER_PORT = 4516;
    static final int DEFAULT_DEPLOYIT_SERVER_SECURE_PORT = 4517;
    static final String DEFAULT_DEPLOYIT_SERVER_HOST = "127.0.0.1";
    static final String EXTENSION_DIR = "ext";
    @Option(name="-secure", usage="Use https to connect to the Deployit server", required=false)
    private boolean secured = false;
    @Option(name="-expose-proxies", required=false)
    private boolean exposeProxies = false;
    @Option(name="-host", usage="Connect to a specified host, defaults to 127.0.0.1 (Optional)", required=false)
    private String host = "127.0.0.1";
    @Option(name="-port", usage="Connect to a specified port, defaults to 4516 (Optional)", required=false)
    private int port = -1;
    @Option(name="-f", usage="Execute a specified python source file (Optional)", required=false, aliases={"-source"})
    private String sourceFileName = null;
    @Option(name="-username", usage="Connect as the specified user (Optional)", required=false)
    private String username;
    @Option(name="-password", usage="Connect with the specified password (Optional)", required=false)
    private String password;
    @Option(name="-configuration", usage="Specify the location of the configuration file (deployit.conf)", required=false)
    private String configLocation = "conf";
    @Argument
    @Option(name="--", handler=StopOptionHandler.class)
    private List<String> scriptArgs = Lists.newArrayList();
    private static final String DEPLOYIT_CONF_FILE_NAME = "deployit.conf";

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port == -1 ? (this.secured ? 4517 : 4516) : this.port;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public boolean interpretSourceFile() {
        return this.sourceFileName != null;
    }

    public boolean isUsernameOnCommandline() {
        return this.username != null;
    }

    public boolean isPasswordOnCommandline() {
        return this.password != null;
    }

    public boolean isExposeProxies() {
        return this.exposeProxies;
    }

    public void setExposeProxies(boolean exposeProxies) {
        this.exposeProxies = exposeProxies;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public File getConfigurationFile() {
        return new File(this.configLocation, DEPLOYIT_CONF_FILE_NAME);
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public String getUrl() {
        return String.format("http%s://%s:%d", this.secured ? "s" : "", this.host, this.getPort());
    }

    public List<String> getScriptArgs() {
        return this.scriptArgs;
    }

    public void setScriptArgs(List<String> scriptArgs) {
        this.scriptArgs = scriptArgs;
    }

    static CliOptions parse(String ... args) {
        CliOptions options = new CliOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar deployit-cli-<version>.jar [options...]");
            parser.printUsage((OutputStream)System.err);
            return null;
        }
        return options;
    }
}

