/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.cli.CliOptions;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySystemState;

public class ScriptEngineBuilder {
    private Map<String, Object> attributes = Maps.newHashMap();

    public ScriptEngine build(CliOptions options) {
        ScriptEngineManager engineManager;
        ScriptEngine jythonEngine;
        if (!options.getScriptArgs().isEmpty()) {
            PySystemState engineSys = new PySystemState();
            if (options.interpretSourceFile()) {
                engineSys.argv.clear();
                engineSys.argv.append((PyObject)Py.newString((String)options.getSourceFileName()));
            }
            for (String s : options.getScriptArgs()) {
                engineSys.argv.append((PyObject)Py.newString((String)s));
            }
            Py.setSystemState((PySystemState)engineSys);
        }
        if ((jythonEngine = (engineManager = new ScriptEngineManager()).getEngineByName("python")) == null) {
            throw new IllegalStateException("Could not find the JythonEngine, is it on the classpath?");
        }
        this.registerAttributes(jythonEngine);
        return jythonEngine;
    }

    private void registerAttributes(ScriptEngine jythonEngine) {
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            jythonEngine.put(entry.getKey(), entry.getValue());
        }
    }

    public void put(String name, Object value) {
        this.attributes.put(name, value);
    }
}

