/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ssl;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.cli.ssl.SelfSignedCertificateTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfSignedCertificateAcceptingSocketFactory
implements SecureProtocolSocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(SelfSignedCertificateAcceptingSocketFactory.class);
    private AtomicReference<SSLContext> sslcontext = new AtomicReference();

    private static SSLContext createLenientSSLContext() {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new SelfSignedCertificateTrustManager(null)}, null);
            return context;
        }
        catch (Exception e) {
            logger.error("Exception setting up the SSL Context.", (Throwable)e);
            throw new HttpClientError("Exception setting up the SSL Context: " + e);
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext.get() == null) {
            this.sslcontext.set(SelfSignedCertificateAcceptingSocketFactory.createLenientSSLContext());
        }
        return this.sslcontext.get();
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port, localHost, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
        Preconditions.checkNotNull((Object)params, (Object)"Parameters should be set");
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(SelfSignedCertificateAcceptingSocketFactory.class);
    }

    public int hashCode() {
        return SelfSignedCertificateAcceptingSocketFactory.class.hashCode();
    }
}

