/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.QueryProxy;
import com.xebialabs.deployit.core.api.RepositoryProxy;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CliObject(name="repository")
@ClassHelp(description="Gateway to doing CRUD operations on all types of CIs")
public class RepositoryClient
extends DocumentedObject {
    private final RepositoryProxy repository;
    private final QueryProxy query;
    private final DescriptorHelper descriptors;
    private static final Logger logger = LoggerFactory.getLogger(RepositoryClient.class);

    public RepositoryClient() {
        this.repository = null;
        this.query = null;
        this.descriptors = null;
    }

    public RepositoryClient(Proxies proxies) {
        this.repository = proxies.getRepository();
        this.query = proxies.getQuery();
        this.descriptors = DescriptorHelper.getInstance(proxies);
    }

    @MethodHelp(description="Create a new CI in the repository with a specific id", parameters={@ParameterHelp(name="id", description="The id of the to-be-created CI"), @ParameterHelp(name="ci", description="The CI (ConfigurationItem) that should be created in the repository")})
    public RepositoryObject create(String id, RepositoryObject object) {
        Response response = this.repository.create(id, object);
        return this.checkForValidations(response);
    }

    private RepositoryObject checkForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        RepositoryObject ci = (RepositoryObject)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse() && !ci.getValidations().isEmpty()) {
            logger.error("Configuration item contained validation errors: {}", (Object)ci.getValidations());
        }
        return ci;
    }

    @MethodHelp(description="Create a new artifact CI in the repository with a specific id", parameters={@ParameterHelp(name="id", description="The id of the to-be-created CI"), @ParameterHelp(name="artifact", description="The Artifact that should be created in the repository")})
    public RepositoryObject create(String id, ArtifactAndData artifact) {
        Response response = this.repository.create(id, artifact);
        return this.checkForValidations(response);
    }

    public RepositoryObjects create(RepositoryObjects repositoryObjects) {
        Response response = this.repository.createMultiple(repositoryObjects);
        return this.checkAllForValidations(response);
    }

    private RepositoryObjects checkAllForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        RepositoryObjects cis = (RepositoryObjects)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse()) {
            for (RepositoryObject repositoryObject : cis.getObjects()) {
                if (repositoryObject.getValidations().isEmpty()) continue;
                logger.error("Configuration item contained validation errors: {}", (Object)repositoryObject.getValidations());
            }
        }
        return cis;
    }

    @MethodHelp(description="Read a CI form the repository", parameters={@ParameterHelp(name="id", description="The id of the CI to read")})
    public RepositoryObject read(String id) {
        return (RepositoryObject)new ResponseExtractor(this.repository.read(id)).getEntity();
    }

    @MethodHelp(description="Update an existing CI in the repository with a specific id", parameters={@ParameterHelp(name="id", description="The id of the existing CI"), @ParameterHelp(name="ci", description="The updated CI (ConfigurationItem) that should be stored in the repository")})
    public RepositoryObject update(String id, RepositoryObject object) {
        Response response = this.repository.update(id, object);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Update an existing artifact in the repository with a specific id", parameters={@ParameterHelp(name="id", description="The id of the existing artifact CI"), @ParameterHelp(name="artifact", description="The updated artifact CI that should be stored in the repository")})
    public RepositoryObject update(String id, ArtifactAndData artifact) {
        Response response = this.repository.update(id, artifact);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Delete a CI with a specific id from the repository", parameters={@ParameterHelp(name="id", description="The id of the CI")})
    public void delete(String id) {
        new ResponseExtractor(this.repository.delete(id));
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository", parameters={@ParameterHelp(name="ciType", description="")})
    public List<String> search(String ciType) {
        String type = this.descriptors.getRegisteredType(ciType);
        if (type == null) {
            System.err.println("Configuration item type [" + type + "] not known.");
            return null;
        }
        RepositoryObjectIds ids = (RepositoryObjectIds)new ResponseExtractor(this.query.list(type, Boolean.FALSE.booleanValue(), 0L, -1L, null, null, null)).getEntity();
        return ids.getRepositoryEntityIds();
    }

    public List<String> search(String ciType, String parent) {
        String type = this.descriptors.getRegisteredType(ciType);
        RepositoryObjectIds ids = (RepositoryObjectIds)new ResponseExtractor(this.query.list(type, Boolean.FALSE.booleanValue(), 0L, -1L, null, parent, null)).getEntity();
        return ids.getRepositoryEntityIds();
    }

    @MethodHelp(description="Read multiple objects from the repostory in one go.", parameters={@ParameterHelp(name="ids", description="The ids of the objects to read")})
    public List<RepositoryObject> read(String ... ids) {
        RepositoryObjectIds repositoryObjectIds = new RepositoryObjectIds();
        repositoryObjectIds.setRepositoryEntityIds(Arrays.asList(ids));
        RepositoryObjects objs = (RepositoryObjects)new ResponseExtractor(this.query.readMultiple(repositoryObjectIds)).getEntity();
        return objs.getObjects();
    }
}

