/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.help;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class PermissionPrinter {
    private PermissionPrinter() {
    }

    public static void listPermissions(Map<String, Set<String>> permissionTargetSet) {
        if (permissionTargetSet == null || permissionTargetSet.isEmpty()) {
            System.out.print("There are no permissions set for the requested user, or the requested user doesn't exist!\n\n");
        } else {
            for (String permissionTarget : permissionTargetSet.keySet()) {
                if (permissionTargetSet.get(permissionTarget).contains("")) {
                    System.out.print(String.format("\nGranted global permission '%s'\n", permissionTarget));
                    continue;
                }
                PermissionPrinter.printSetOfValues(String.format("\nGranted permission '%s' on:\n", permissionTarget), permissionTargetSet.get(permissionTarget));
                System.out.println();
            }
        }
    }

    public static void listPermissionsOnTargets(Collection<? extends String> targets, Map<String, Set<String>> targetsWithPermissions) {
        for (String string : targets) {
            PermissionPrinter.listPermissionsOnTarget(string, targetsWithPermissions);
        }
    }

    public static void listPermissionsOnTarget(String target, Map<String, Set<String>> targetsWithPermissions) {
        if (targetsWithPermissions == null || targetsWithPermissions.isEmpty()) {
            System.out.print(String.format("There are no permissions set for the requested user on '%s' or the requested user doesn't exist!\n\n", target));
        } else {
            System.out.println();
            if (targetsWithPermissions.containsKey(target)) {
                PermissionPrinter.printSetOfValues(String.format("Permissions on '%s':\n", target), targetsWithPermissions.get(target));
            } else if (targetsWithPermissions.size() == 1 && targetsWithPermissions.containsKey("")) {
                PermissionPrinter.printSetOfValues(String.format("Permissions on '%s':\n", target), targetsWithPermissions.get(""));
            } else {
                System.out.print(String.format("Permissions on '%s':\n\tNo permissions found\n", target));
            }
            System.out.println();
        }
    }

    public static void listPermissionsOnTargets(Map<String, Set<String>> targetsWithPermissions) {
        if (targetsWithPermissions == null || targetsWithPermissions.isEmpty()) {
            System.out.print("There are no permissions set for the requested user, or the requested user doesn't exist!\n\n");
        } else {
            if (targetsWithPermissions.containsKey("")) {
                PermissionPrinter.printSetOfValues("\nGlobal permissions:\n", targetsWithPermissions.get(""));
            }
            for (Map.Entry<String, Set<String>> target : targetsWithPermissions.entrySet()) {
                if (target.getKey().equals("")) continue;
                PermissionPrinter.printSetOfValues(String.format("\nPermissions on '%s':\n", target.getKey()), target.getValue());
            }
            System.out.println();
        }
    }

    private static void printSetOfValues(String text, Set<String> values) {
        System.out.print(text);
        for (String value : values) {
            System.out.print(String.format("\t %s\n", value));
        }
    }
}

