/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.core.api.dto.Artifact;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItem;
import java.util.Map;
import java.util.TreeSet;

@CliObject(name="factory")
@ClassHelp(description="Helper that can construct Configuration Items (CI) and Artifacts")
public class ObjectFactory
extends DocumentedObject {
    private DescriptorHelper descriptors;

    public ObjectFactory() {
    }

    public ObjectFactory(Proxies proxies) {
        this.descriptors = DescriptorHelper.getInstance(proxies);
    }

    @MethodHelp(description="Construct a CI of a specified type", parameters={@ParameterHelp(name="id", description="The id of the CI"), @ParameterHelp(name="ciType", description="The type of the CI")})
    public ConfigurationItem configurationItem(String id, String ciType) {
        return this.ci(id, ciType, Maps.newHashMap());
    }

    @MethodHelp(description="Construct a CI of a specified type with specified values", parameters={@ParameterHelp(name="id", description="The id of the CI"), @ParameterHelp(name="ciType", description="The type of the CI"), @ParameterHelp(name="values", description="The values of the CI in a map.")})
    public ConfigurationItem configurationItem(String id, String ciType, Map<String, Object> values) {
        return this.ci(id, ciType, values);
    }

    private ConfigurationItem ci(String id, String ciType, Map<String, Object> values) {
        Preconditions.checkArgument((boolean)this.isValidType(ciType), (String)"Unknown CI type %s", (Object[])new Object[]{ciType});
        String type = this.descriptors.getRegisteredType(ciType);
        ConfigurationItem configurationItem = new ConfigurationItem(type);
        configurationItem.setId(id);
        configurationItem.setValues((Map)Maps.newHashMap(values));
        return configurationItem;
    }

    @MethodHelp(description="Construct an artifact of a specific type with associated data", parameters={@ParameterHelp(name="id", description="The id of the artifact"), @ParameterHelp(name="ciType", description="The type of the artifact"), @ParameterHelp(name="values", description="The values for the artifact in a map."), @ParameterHelp(name="data", description="The data of the artifact that is to be uploaded")}, returns="An Artifact with data that can be stored in Deployit.")
    public ArtifactAndData artifact(String id, String ciType, Map<String, Object> values, byte[] data) {
        Preconditions.checkArgument((boolean)this.isValidType(ciType), (String)"Unknown CI type %s", (Object[])new Object[]{ciType});
        String type = this.descriptors.getRegisteredType(ciType);
        Artifact artifact = new Artifact(type);
        artifact.setId(id);
        artifact.setValues((Map)Maps.newHashMap(values));
        return new ArtifactAndData(artifact, data);
    }

    @MethodHelp(description="Prints all registered configuration item types.")
    public void types() {
        TreeSet typeSet = Sets.newTreeSet(this.descriptors.types());
        System.out.printf("The registered configuration item types are:\n%s\n\n", typeSet);
    }

    private boolean isValidType(String ciType) {
        return this.descriptors.isTypeRegistered(ciType);
    }
}

