/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.DescriptorProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemMethodDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyKind;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class DescriptorHelper {
    private static DescriptorHelper instance;
    private DescriptorProxy descriptorProxy;
    private Map<String, String> simpleNameMap = Maps.newHashMap();

    public DescriptorHelper(Proxies proxies) {
        this.descriptorProxy = proxies.getDescriptors();
        this.initialize();
    }

    private void initialize() {
        ConfigurationItemDescriptorList descriptors = (ConfigurationItemDescriptorList)new ResponseExtractor(this.descriptorProxy.list()).getEntity();
        this.registerSimpleNames(descriptors);
    }

    private void registerSimpleNames(ConfigurationItemDescriptorList descriptors) {
        for (ConfigurationItemDescriptorDto configurationItemDescriptorDto : descriptors.getDescriptors()) {
            this.simpleNameMap.put(configurationItemDescriptorDto.getSimpleName(), configurationItemDescriptorDto.getType());
        }
    }

    public static DescriptorHelper getInstance(Proxies proxies) {
        if (instance == null) {
            instance = new DescriptorHelper(proxies);
        }
        return instance;
    }

    public String getRegisteredType(String shortCiType) {
        return this.simpleNameMap.get(shortCiType);
    }

    public boolean isTypeRegistered(String shortCiType) {
        return this.simpleNameMap.containsKey(shortCiType);
    }

    public static void describe(String typeName) {
        instance.describeType(typeName);
    }

    private void describeType(String shortType) {
        String type = this.getRegisteredType(shortType);
        if (type == null) {
            System.out.println();
            System.out.printf("No ConfigurationItem named \"%s\" found.\n", shortType);
            System.out.println();
            return;
        }
        ConfigurationItemDescriptorDto ciDescriptor = (ConfigurationItemDescriptorDto)new ResponseExtractor(this.descriptorProxy.find(type)).getEntity();
        System.out.println();
        System.out.printf("ConfigurationItem \"%s\" (%s):\n", ciDescriptor.getSimpleName(), ciDescriptor.getType());
        System.out.printf("Description: %s\n", ciDescriptor.getDescription());
        System.out.println("Control tasks:");
        for (ConfigurationItemMethodDescriptorDto controlTask : ciDescriptor.getControlTasks()) {
            System.out.printf("\t. %s: %s\n", controlTask.getName(), controlTask.getDescription());
        }
        System.out.println("Properties:");
        for (ConfigurationItemPropertyDescriptorDto property : ciDescriptor.getPropertyDescriptors()) {
            System.out.printf("\t%s %s(%s): %s\n", this.getPropertyModifier(property), property.getName(), this.getType(property), property.getDescription());
            if (property.getType() != ConfigurationItemPropertyKind.ENUM) continue;
            System.out.printf("\t\tValues: %s\n", Arrays.toString(property.getEnumValues()));
        }
        System.out.println();
        System.out.println("Properties marked with a '!' are required for discovery.");
        System.out.println("Properties marked with a '*' are required.");
        System.out.println();
    }

    private String getPropertyModifier(ConfigurationItemPropertyDescriptorDto property) {
        if (property.isDiscoveryRequired()) {
            return "!";
        }
        return property.isRequired() ? "*" : "-";
    }

    private String getType(ConfigurationItemPropertyDescriptorDto property) {
        ConfigurationItemPropertyKind type = property.getType();
        if (type == ConfigurationItemPropertyKind.CI) {
            return property.getPropertyClassname();
        }
        if (type == ConfigurationItemPropertyKind.SET_OF_CI) {
            return String.format("Set<%s>", property.getCollectionMemberClassname());
        }
        if (type == ConfigurationItemPropertyKind.SET_OF_STRING) {
            return "Set<String>";
        }
        if (type == ConfigurationItemPropertyKind.LIST_OF_OBJECT) {
            return String.format("List<%s>", property.getCollectionMemberClassname());
        }
        return property.getType().name();
    }

    public Set<String> types() {
        return this.simpleNameMap.keySet();
    }
}

