/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfSignedCertificateTrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Logger logger = LoggerFactory.getLogger(SelfSignedCertificateTrustManager.class);

    public SelfSignedCertificateTrustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length == 0) {
            throw new NoSuchAlgorithmException("Could not find a trustmanager.");
        }
        this.standardTrustManager = (X509TrustManager)trustManagerArray[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (x509CertificateArray != null && logger.isDebugEnabled()) {
            logger.debug("Server certificate chain:");
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                logger.debug("X509Certificate[" + i + "]=" + x509CertificateArray[i]);
            }
        }
        if (x509CertificateArray != null && x509CertificateArray.length == 1) {
            x509CertificateArray[0].checkValidity();
        } else {
            this.standardTrustManager.checkServerTrusted(x509CertificateArray, string);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

