/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.cli.Cli;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.ScriptEngineBuilder;
import com.xebialabs.deployit.cli.help.HelpScanner;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jline.console.ConsoleReader;

public class Interpreter {
    private ScriptEngine scriptEngine;
    private CliOptions options;
    private ScriptContext scriptContext;
    private ConsoleReader consoleReader;

    public Interpreter(ConsoleReader consoleReader, ScriptEngineBuilder scriptEngineBuilder, CliOptions options) {
        this.consoleReader = consoleReader;
        this.scriptEngine = scriptEngineBuilder.build(options);
        this.options = options;
        this.scriptContext = new SimpleScriptContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interpret() throws Exception {
        block9: {
            try {
                if (this.options.interpretSourceFile()) {
                    this.scriptContext.setAttribute("javax.script.filename", this.options.getSourceFileName(), 100);
                    FileReader reader = new FileReader(this.options.getSourceFileName());
                    try {
                        this.evaluate(reader);
                        break block9;
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)reader);
                    }
                }
                try {
                    this.advancedRepl(this.consoleReader);
                }
                catch (Exception e) {
                    throw new IllegalStateException("The REPL gave an exception!", e);
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + this.options.getSourceFileName() + " could not be read, reason:" + e.getMessage());
                System.exit(1);
            }
            catch (ScriptException e) {
                System.err.println("An error occurred while interpreting file " + this.options.getSourceFileName() + ", reason:" + e.getMessage());
                System.exit(1);
            }
        }
    }

    public Object evaluate(Reader reader) throws ScriptException {
        return this.scriptEngine.eval(reader, this.scriptContext);
    }

    Object evaluate(String expression) throws ScriptException {
        if (expression == null) {
            return null;
        }
        return this.scriptEngine.eval(expression, this.scriptContext);
    }

    private void advancedRepl(ConsoleReader consoleReader) throws Exception {
        while (true) {
            String line;
            String trimmed;
            String string = trimmed = (line = consoleReader.readLine(this.getPrompt())) != null ? line.trim() : null;
            if (trimmed == null || trimmed.startsWith("quit") || trimmed.startsWith("exit")) break;
            if (trimmed.startsWith("help")) {
                HelpScanner.printHelp();
                continue;
            }
            try {
                Object evaluationResult = this.evaluate(line);
                if (evaluationResult instanceof String) {
                    System.out.println((String)evaluationResult);
                    continue;
                }
                if (evaluationResult == null) continue;
                System.out.println("Ok [returned an object of type " + evaluationResult.getClass().getSimpleName() + "]");
            }
            catch (ScriptException e) {
                System.err.println("Exception: " + e);
            }
        }
        this.exit();
    }

    protected void exit() throws Exception {
        System.out.println("Bye bye!");
    }

    String getPrompt() {
        String prompt = "deployit > ";
        String username = Cli.getAuthentication().username;
        if (username != null) {
            prompt = username + " > ";
        }
        return prompt;
    }
}

