/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PrintHelper {
    private final Set<String> repositoryObjectParentIds = Sets.newHashSet();

    private PrintHelper() {
    }

    public static final PrintHelper getInstance() {
        return new PrintHelper();
    }

    public void printCi(RepositoryObject object, Proxies proxies) {
        this.printTopLevelCiWithIndent(object, "", proxies);
    }

    public void printCis(Collection<RepositoryObject> cis, Proxies proxies) {
        this.repositoryObjectParentIds.addAll(Collections2.transform(cis, (Function)new Function<RepositoryObject, String>(){

            public String apply(RepositoryObject input) {
                return input.getId();
            }
        }));
        for (RepositoryObject ci : cis) {
            this.printTopLevelCiWithIndent(ci, "", proxies);
        }
    }

    private void printTopLevelCiWithIndent(RepositoryObject object, String indent, Proxies proxies) {
        System.out.println(object.getType());
        this.printCiProperties(object, indent, proxies);
    }

    private void printCiProperties(RepositoryObject object, String indent, Proxies proxies) {
        this.repositoryObjectParentIds.add(object.getId());
        this.println(indent, "id", object.getId(), false);
        this.printCalendar(indent, "lastModified", object.getLastModified(), false);
        this.println(indent, "values", null, true);
        Map<String, ConfigurationItemPropertyDescriptorDto> pds = this.getPropertyDescriptors(object, proxies);
        this.printValues(object, indent + "    ", proxies, pds);
    }

    private void printValues(RepositoryObject object, String indent, Proxies proxies, Map<String, ConfigurationItemPropertyDescriptorDto> pds) {
        Set entries = object.getValues().entrySet();
        Iterator entryIt = entries.iterator();
        block7: while (entryIt.hasNext()) {
            Map.Entry entry = entryIt.next();
            ConfigurationItemPropertyDescriptorDto pd = pds.get(entry.getKey());
            boolean last = !entryIt.hasNext();
            String deepIndent = indent + (entryIt.hasNext() ? "|   " : "    ");
            if (pd == null) {
                this.println(indent, "(INVALID) " + (String)entry.getKey(), entry.getValue().toString(), last);
                continue;
            }
            switch (pd.getType()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.println(indent, (String)entry.getKey(), entry.getValue().toString(), last);
                    break;
                }
                case SET_OF_STRING: 
                case LIST_OF_STRING: {
                    this.println(indent, (String)entry.getKey(), null, last);
                    Collection strings = (Collection)entry.getValue();
                    Iterator stringIt = strings.iterator();
                    while (stringIt.hasNext()) {
                        String string = (String)stringIt.next();
                        this.println(deepIndent, string, null, !stringIt.hasNext());
                    }
                    continue block7;
                }
                case MAP_STRING_STRING: {
                    this.println(indent, (String)entry.getKey(), null, last);
                    Map stringMap = (Map)entry.getValue();
                    for (Map.Entry mapEntry : stringMap.entrySet()) {
                        this.println(deepIndent, (String)mapEntry.getKey(), (String)mapEntry.getValue(), !entryIt.hasNext());
                    }
                    continue block7;
                }
                case CI: {
                    String id = (String)entry.getValue();
                    if (!this.repositoryObjectParentIds.contains(id)) {
                        RepositoryObject nested = (RepositoryObject)new ResponseExtractor(proxies.getRepository().read(id)).getEntity();
                        this.println(indent, (String)entry.getKey(), nested.getType(), last);
                        this.printCiProperties(nested, deepIndent, proxies);
                        break;
                    }
                    this.println(indent, (String)entry.getKey(), "REFERENCE => " + id, last);
                    break;
                }
                case SET_OF_CI: 
                case LIST_OF_CI: {
                    this.println(indent, (String)entry.getKey(), null, last);
                    Collection ids = (Collection)entry.getValue();
                    this.printSetOfCis(deepIndent, ids, proxies);
                    break;
                }
            }
        }
    }

    private void printSetOfCis(String indent, Collection<String> ids, Proxies proxies) {
        Iterator<String> idIt = ids.iterator();
        while (idIt.hasNext()) {
            String nestedid = idIt.next();
            if (!this.repositoryObjectParentIds.contains(nestedid)) {
                RepositoryObject nestedCi = (RepositoryObject)new ResponseExtractor(proxies.getRepository().read(nestedid)).getEntity();
                this.println(indent, nestedCi.getType(), null, !idIt.hasNext());
                this.printCiProperties(nestedCi, indent + (idIt.hasNext() ? "|   " : "    "), proxies);
                continue;
            }
            this.println(indent, "REFERENCE => " + nestedid, null, !idIt.hasNext());
        }
    }

    private Map<String, ConfigurationItemPropertyDescriptorDto> getPropertyDescriptors(RepositoryObject object, Proxies proxies) {
        ConfigurationItemDescriptorDto descriptor = (ConfigurationItemDescriptorDto)new ResponseExtractor(proxies.getReferenceData().find(object.getType())).getEntity();
        List propertyDescriptors = descriptor.getPropertyDescriptors();
        HashMap pds = Maps.newHashMap();
        for (ConfigurationItemPropertyDescriptorDto propertyDescriptor : propertyDescriptors) {
            pds.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return pds;
    }

    private void println(String indent, String key, String value, boolean last) {
        System.out.println(indent + (last ? "\\-- " : "+-- ") + key + (value != null ? ": " + value : ""));
    }

    private void printCalendar(String indent, String key, Calendar value, boolean last) {
        if (value != null) {
            this.println(indent, key, new SimpleDateFormat("yyyy-MM-dd hh:MM:ss.SSS").format(value.getTime()), last);
        } else {
            this.println(indent, key, null, last);
        }
    }
}

