package com.xebialabs.deployit.cli.rest;

import javax.ws.rs.core.Response;

import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;

import com.xebialabs.deployit.booter.remote.resteasy.InternalServerErrorClientResponseInterceptor;

/**
 */
public class ResponseExtractor {

    private final ClientResponse<?> response;

    public static <T> T getEntity(final Response response) {
        return new ResponseExtractor(response).<T> getEntity();
    }

    public ResponseExtractor(final Response response) {
        if (!(response instanceof ClientResponse)) {
            throw new IllegalArgumentException("Not a client response: " + response);
        }
        this.response = (ClientResponse<?>) response;
        checkResponse();
    }

    private void checkResponse() {
        final int status = response.getStatus();
        if (notOk(status)) {
            new InternalServerErrorClientResponseInterceptor().handle(response);
        }
    }

    private static boolean notOk(final int status) {
        return 399 < status && status < 699;
    }

    @SuppressWarnings({ "unchecked" })
    public <T> T getEntity() {
        try {
            return (T) ((BaseClientResponse<?>) response).getEntity();
        } finally {
            close();
        }
    }

    public boolean isValidResponse() {
        return !notOk(response.getStatus());
    }

    public void close() {
        ((BaseClientResponse<?>) response).releaseConnection();
    }
}
