/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.rest;

import com.xebialabs.deployit.booter.remote.resteasy.InternalServerErrorClientResponseInterceptor;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;

public class ResponseExtractor {
    private final ClientResponse<?> response;

    public static <T> T getEntity(Response response) {
        return new ResponseExtractor(response).getEntity();
    }

    public ResponseExtractor(Response response) {
        if (!(response instanceof ClientResponse)) {
            throw new IllegalArgumentException("Not a client response: " + response);
        }
        this.response = (ClientResponse)response;
        this.checkResponse();
    }

    private void checkResponse() {
        int status = this.response.getStatus();
        if (ResponseExtractor.notOk(status)) {
            new InternalServerErrorClientResponseInterceptor().handle(this.response);
        }
    }

    private static boolean notOk(int status) {
        return 399 < status && status < 699;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getEntity() {
        try {
            Object object = ((BaseClientResponse)this.response).getEntity();
            return (T)object;
        }
        finally {
            this.close();
        }
    }

    public boolean isValidResponse() {
        return !ResponseExtractor.notOk(this.response.getStatus());
    }

    public void close() {
        ((BaseClientResponse)this.response).releaseConnection();
    }
}

