/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.cli.CliCompleter;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.Interpreter;
import com.xebialabs.deployit.cli.ScriptEngineBuilder;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.help.HelpScanner;
import com.xebialabs.deployit.cli.util.Closeables;
import com.xebialabs.deployit.cli.util.PasswordEncrypter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cli {
    public static final String CLI_PASSWORD_PROPERTY_NAME = "cli.password";
    public static final String CLI_USERNAME_PROPERTY_NAME = "cli.username";
    private static final AtomicReference<Properties> properties = new AtomicReference();
    private ConsoleReader consoleReader;
    private static final FilenameFilter CLI_EXTENSION_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".py") || name.endsWith(".cli");
        }
    };
    private ScriptEngineBuilder scriptEngine;
    private CliOptions options;
    private DeployitCommunicator communicator;
    private PasswordEncrypter encrypter;
    private Set<String> cliObjectNames;
    private static final Logger logger = LoggerFactory.getLogger(Cli.class);

    public Cli(CliOptions options) throws Exception {
        this(options, null);
    }

    public Cli(CliOptions options, ConsoleReader consoleReader) throws Exception {
        this.options = options;
        this.consoleReader = consoleReader;
        this.scriptEngine = new ScriptEngineBuilder();
        this.initialize();
    }

    private void printBanner() {
        this.bannerPrint("Welcome to the XL Deploy Jython CLI!");
        this.bannerPrint("Type 'help' to learn about the objects you can use to interact with XL Deploy.");
        this.bannerPrint("");
    }

    private void initialize() throws Exception {
        PasswordEncrypter.init();
        this.encrypter = PasswordEncrypter.getInstance();
        BooterConfig.Builder builder = BooterConfig.builder().withHost(this.options.getHost()).withContext(this.options.getContext()).withPort(this.options.getPort()).withProxyHost(this.options.getProxyHost()).withProxyPort(this.options.getProxyPort()).withSocketTimeout(this.options.getSocketTimeout());
        if (this.options.isSecured()) {
            builder.withProtocol(BooterConfig.Protocol.HTTPS);
        }
        this.createCredentials(builder);
        if (this.consoleReader != null) {
            this.consoleReader.addCompleter((Completer)new CliCompleter(this.consoleReader));
        }
        BooterConfig config = builder.build();
        RemoteBooter.boot((BooterConfig)config);
        this.communicator = RemoteBooter.getCommunicator((BooterConfig)config);
        this.printBanner();
        ProxiesInstance proxies = this.createAndRegisterProxies(config);
        this.registerCliObjects(proxies);
    }

    private ProxiesInstance createAndRegisterProxies(BooterConfig config) {
        ProxiesInstance proxies = new ProxiesInstance(config);
        if (this.options.isExposeProxies()) {
            System.out.println("Exposing Proxies!");
            this.scriptEngine.put("proxies", proxies);
        }
        return proxies;
    }

    public static void main(String[] args) throws Exception {
        CliOptions options = CliOptions.parse(args);
        if (options == null) {
            return;
        }
        new Cli(options, Cli.setupConsole()).getNewInterpreter().interpret();
    }

    private static ConsoleReader setupConsole() throws IOException {
        final Terminal terminal = Cli.getTerminal();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    terminal.restore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ConsoleReader cr = new ConsoleReader();
        cr.setExpandEvents(false);
        return cr;
    }

    private static Terminal getTerminal() {
        Terminal terminal;
        try {
            terminal = TerminalFactory.get();
        }
        catch (Throwable t) {
            System.err.println("[WARNING] Error loading terminal, using fallback. Your terminal will have reduced functionality. Please see: http://docs.xebialabs.com/general/faq.html#fallback-terminal");
            logger.warn("Error loading terminal, using fallback. Your terminal will have reduced functionality.");
            TerminalFactory.configure((TerminalFactory.Type)TerminalFactory.Type.NONE);
            terminal = TerminalFactory.get();
        }
        return terminal;
    }

    public Interpreter getNewInterpreter() throws ScriptException, FileNotFoundException {
        Interpreter interpreter = new Interpreter(this.consoleReader, this.scriptEngine, this.communicator, this.options, this.cliObjectNames);
        this.readExtensions(interpreter);
        return interpreter;
    }

    private void registerCliObjects(ProxiesInstance proxies) throws Exception {
        Scannit scannit = new Scannit(Configuration.config().with(new AbstractScanner[]{new TypeAnnotationScanner()}).scan("com.xebialabs"));
        Set classes = scannit.getTypesAnnotatedWith(CliObject.class);
        this.cliObjectNames = classes.stream().map(cliObject -> cliObject.getAnnotation(CliObject.class).name()).collect(Collectors.toSet());
        for (Class cliObject2 : classes) {
            Constructor constructor = cliObject2.getConstructor(ProxiesInstance.class);
            Object o = constructor.newInstance(proxies);
            String name = cliObject2.getAnnotation(CliObject.class).name();
            this.scriptEngine.put(name, o);
        }
        HelpScanner.init(classes);
        if (!this.options.isQuiet()) {
            HelpScanner.printHelp();
        }
    }

    public void createCredentials(BooterConfig.Builder builder) throws IOException {
        builder.withCredentials(this.retrieveUsername(), this.retrievePassword());
    }

    private String retrieveUsername() throws IOException {
        String username = this.options.isUsernameOnCommandline() ? this.options.getUsername() : (this.deployitConfigurationFileExists() ? this.readFromProperties(CLI_USERNAME_PROPERTY_NAME) : this.consoleReader.readLine("Username: "));
        return username;
    }

    private String retrievePassword() throws IOException {
        String password = this.options.isPasswordOnCommandline() ? this.options.getPassword() : (this.deployitConfigurationFileExists() ? this.encrypter.ensureDecrypted(this.readFromProperties(CLI_PASSWORD_PROPERTY_NAME)) : this.consoleReader.readLine("Password: ", Character.valueOf('\u0000')));
        return password;
    }

    private boolean deployitConfigurationFileExists() {
        return this.options.getConfigurationFile().exists();
    }

    private String readFromProperties(String key) throws IOException {
        if (properties.get() == null) {
            Properties props = this.readDeployitConfigurationFile();
            properties.set(props);
        }
        return properties.get().getProperty(key);
    }

    private Properties readDeployitConfigurationFile() throws IOException {
        return Cli.readDeployitConfigurationFile(this.options, this.encrypter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties readDeployitConfigurationFile(CliOptions options, PasswordEncrypter encrypter) throws IOException {
        Properties props = new Properties();
        try (FileInputStream inStream = new FileInputStream(options.getConfigurationFile());){
            props.load(inStream);
        }
        String cliPassword = props.getProperty(CLI_PASSWORD_PROPERTY_NAME);
        if (cliPassword != null && !encrypter.isEncrypted(cliPassword)) {
            cliPassword = encrypter.encrypt(cliPassword);
            props.setProperty(CLI_PASSWORD_PROPERTY_NAME, cliPassword);
            if (options.getConfigurationFile().canWrite()) {
                logger.info("Writing configuration file [{}] with encrypted cli.password", (Object)options.getConfigurationFile());
                FileOutputStream outStream = new FileOutputStream(options.getConfigurationFile());
                try {
                    props.store(outStream, "XL Deploy CLI configuration file");
                }
                catch (IOException exc) {
                    logger.error("Error while updating configuration file [{}]: [{}]", (Object)options.getConfigurationFile(), (Object)exc.getMessage());
                }
                finally {
                    Closeables.closeQuietly(outStream);
                }
                logger.info("Done writing configuration file [{}] with encrypted cli.password", (Object)options.getConfigurationFile());
            } else {
                logger.warn("Cannot write configuration file [{}], not encrypting cli.password", (Object)options.getConfigurationFile());
            }
        }
        return props;
    }

    private void readExtensions(Interpreter interpreter) throws ScriptException, FileNotFoundException {
        File[] files;
        File extensionDir = new File("ext");
        if (!extensionDir.exists() || !extensionDir.isDirectory()) {
            System.out.println("No extension directory present.");
            return;
        }
        for (File extension : files = extensionDir.listFiles(CLI_EXTENSION_FILTER)) {
            this.bannerPrint("Reading extension: " + extension);
            interpreter.evaluate(new FileReader(extension));
        }
    }

    void bannerPrint(String line) {
        if (!this.options.isQuiet()) {
            System.out.println(line);
        }
    }
}

