/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.core.api.BannerService;
import com.xebialabs.deployit.core.api.ConfigurationService;
import com.xebialabs.deployit.core.api.InternalComparisonProxy;
import com.xebialabs.deployit.core.api.InternalHistoryProxy;
import com.xebialabs.deployit.core.api.InternalReportProxy;
import com.xebialabs.deployit.core.api.InternalSecurityProxy;
import com.xebialabs.deployit.core.api.PackageExportProxy;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.InspectionService;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.PermissionService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.TaskBlockService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.UserService;

public class ProxiesInstance {
    private final DeployitCommunicator communicator;

    public ProxiesInstance(BooterConfig c) {
        this.communicator = RemoteBooter.getCommunicator((BooterConfig)c);
        this.registerProxies(c.getUrl());
    }

    private void registerProxies(String url) {
        this.communicator.getProxies().registerProxy(url, InternalReportProxy.class);
        this.communicator.getProxies().registerProxy(url, InternalSecurityProxy.class);
        this.communicator.getProxies().registerProxy(url, InternalComparisonProxy.class);
        this.communicator.getProxies().registerProxy(url, PackageExportProxy.class);
        this.communicator.getProxies().registerProxy(url, InternalHistoryProxy.class);
        this.communicator.getProxies().registerProxy(url, BannerService.class);
    }

    private <T> T getRestEasyProxyInstance(Class<T> proxyClass) {
        return (T)this.communicator.getProxies().getProxyInstance(proxyClass);
    }

    public BannerService getBanner() {
        return this.getRestEasyProxyInstance(BannerService.class);
    }

    public ControlService getControlTask() {
        return this.getRestEasyProxyInstance(ControlService.class);
    }

    public DeploymentService getDeployment() {
        return this.getRestEasyProxyInstance(DeploymentService.class);
    }

    public PackageService getImportablePackage() {
        return this.getRestEasyProxyInstance(PackageService.class);
    }

    public RepositoryService getRepository() {
        return this.getRestEasyProxyInstance(RepositoryService.class);
    }

    public InspectionService getDiscovery() {
        return this.getRestEasyProxyInstance(InspectionService.class);
    }

    public TaskService getTaskRegistry() {
        return this.getRestEasyProxyInstance(TaskService.class);
    }

    public TaskBlockService getTaskBlockRegistry() {
        return this.getRestEasyProxyInstance(TaskBlockService.class);
    }

    public UserService getUser() {
        return this.getRestEasyProxyInstance(UserService.class);
    }

    public MetadataService getReferenceData() {
        return this.getRestEasyProxyInstance(MetadataService.class);
    }

    public ConfigurationService getConfiguration() {
        return this.getRestEasyProxyInstance(ConfigurationService.class);
    }

    public InternalReportProxy getReport() {
        return this.getRestEasyProxyInstance(InternalReportProxy.class);
    }

    public PermissionService getPermissions() {
        return this.getRestEasyProxyInstance(PermissionService.class);
    }

    public InternalSecurityProxy getInternalSecurity() {
        return this.getRestEasyProxyInstance(InternalSecurityProxy.class);
    }

    public PackageExportProxy getExportProxy() {
        return this.getRestEasyProxyInstance(PackageExportProxy.class);
    }

    public ServerService getServer() {
        return this.getRestEasyProxyInstance(ServerService.class);
    }

    public InternalComparisonProxy getComparison() {
        return this.getRestEasyProxyInstance(InternalComparisonProxy.class);
    }

    public RoleService getRoleService() {
        return this.getRestEasyProxyInstance(RoleService.class);
    }

    public InternalHistoryProxy getHistoryService() {
        return this.getRestEasyProxyInstance(InternalHistoryProxy.class);
    }

    public DeployitCommunicator getCommunicator() {
        return this.communicator;
    }
}

