/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.task;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.community.wasext.step.PluginConfigurationCopyStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import java.util.Map;

public class ManagedWebServerTasks {
    private static final String STOP_SCRIPT_PROPERTY = "stopScript";
    private static final String START_SCRIPT_PROPERTY = "startScript";
    private static final String STOP_ORDER_PROPERTY = "stopOrder";
    private static final String START_ORDER_PROPERTY = "startOrder";
    private static final String GENERATE_PLUGIN_SCRIPT_PROPERTY = "generatePluginScript";
    private static final String PROPAGATE_PLUGIN_SCRIPT_PROPERTY = "propagatePluginScript";
    private static final String GENERATE_PLUGIN_ORDER_PROPERTY = "generatePluginOrder";
    private static final String PROPAGATE_PLUGIN_ORDER_PROPERTY = "propagatePluginOrder";

    public static void stop(ManagedWebServer webserver, DeploymentPlanningContext ctx) {
        ManagedWebServerTasks.stop(webserver, ctx, (Integer)webserver.getProperty(STOP_ORDER_PROPERTY));
    }

    protected static void stop(ManagedWebServer webserver, DeploymentPlanningContext ctx, int order) {
        ctx.addStep((DeploymentStep)new PythonDeploymentStep(order, (PythonManagingContainer)webserver.getNode().getCell(), (String)webserver.getProperty(STOP_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)webserver), String.format("Stop web server '%s'", webserver.getName())));
    }

    public static void start(ManagedWebServer webserver, DeploymentPlanningContext ctx) {
        ManagedWebServerTasks.start(webserver, ctx, (Integer)webserver.getProperty(START_ORDER_PROPERTY));
    }

    protected static void start(ManagedWebServer webserver, DeploymentPlanningContext ctx, int order) {
        ctx.addStep((DeploymentStep)new PythonDeploymentStep(order, (PythonManagingContainer)webserver.getNode().getCell(), (String)webserver.getProperty(START_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)webserver), String.format("Start web server '%s'", webserver.getName())));
    }

    public static void restart(ManagedWebServer webserver, DeploymentPlanningContext ctx) {
        int startOrder = (Integer)webserver.getProperty(START_ORDER_PROPERTY);
        ManagedWebServerTasks.stop(webserver, ctx, startOrder - 2);
        ManagedWebServerTasks.start(webserver, ctx, startOrder);
    }

    public static void generatePlugin(ManagedWebServer webserver, DeploymentPlanningContext ctx) {
        ctx.addStep((DeploymentStep)new PythonDeploymentStep(((Integer)webserver.getProperty(GENERATE_PLUGIN_ORDER_PROPERTY)).intValue(), (PythonManagingContainer)webserver.getNode().getCell(), (String)webserver.getProperty(GENERATE_PLUGIN_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)webserver), String.format("Generate web server plugin for '%s'", webserver.getName())));
    }

    public static void propagatePlugin(ManagedWebServer webserver, DeploymentPlanningContext ctx) {
        if (webserver.getProperty("host") != null) {
            ctx.addStep((DeploymentStep)new PluginConfigurationCopyStep((Integer)webserver.getProperty(PROPAGATE_PLUGIN_ORDER_PROPERTY), webserver));
        } else {
            ctx.addStep((DeploymentStep)new PythonDeploymentStep(((Integer)webserver.getProperty(PROPAGATE_PLUGIN_ORDER_PROPERTY)).intValue(), (PythonManagingContainer)webserver.getNode().getCell(), (String)webserver.getProperty(PROPAGATE_PLUGIN_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)webserver), String.format("Propagate web server plugin to '%s'", webserver.getName())));
        }
    }
}

