/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.Collection;

public class Predicates {
    public static Predicate<Type> subtypeOf(Type type) {
        return new IsSubtypeOf(type);
    }

    public static Predicate<ConfigurationItem> instanceOf(Type type) {
        return com.google.common.base.Predicates.compose(Predicates.subtypeOf(type), (Function)new Function<ConfigurationItem, Type>(){

            public Type apply(ConfigurationItem input) {
                return input.getType();
            }
        });
    }

    public static Predicate<Delta> deltaOf(Type type) {
        return com.google.common.base.Predicates.compose(Predicates.instanceOf(type), Predicates.extractDeployed());
    }

    public static Function<Delta, Deployed<?, ?>> extractDeployed() {
        return new ExtractDeployed();
    }

    public static Predicate<Delta> operationIs(Operation operationToMatch) {
        return new OperationEquals(operationToMatch);
    }

    private static class ExtractDeployed
    implements Function<Delta, Deployed<?, ?>> {
        private ExtractDeployed() {
        }

        public Deployed<?, ?> apply(Delta input) {
            return input.getOperation().equals((Object)Operation.DESTROY) ? input.getPrevious() : input.getDeployed();
        }
    }

    private static class IsSubtypeOf
    implements Predicate<Type> {
        private final Collection<Type> subtypes;

        public IsSubtypeOf(Type typeToMatch) {
            this.subtypes = DescriptorRegistry.getSubtypes((Type)typeToMatch);
            this.subtypes.add(typeToMatch);
        }

        public boolean apply(Type input) {
            return this.subtypes.contains(input);
        }
    }

    private static class OperationEquals
    implements Predicate<Delta> {
        private final Operation operationToMatch;

        protected OperationEquals(Operation operationToMatch) {
            this.operationToMatch = operationToMatch;
        }

        public boolean apply(Delta input) {
            return input.getOperation().equals((Object)this.operationToMatch);
        }
    }
}

