/*
 * @(#)WasClusterSteps.java     2 Oct 2011
 *
 * Copyright © 2010 Andrew Phillips.
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */
package com.xebialabs.deployit.community.wasext.task;

import static java.lang.String.format;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.was.container.Cell;

public class CellTasks {
    private static final String UPDATE_GLOBAL_PLUGIN_SCRIPT_PROPERTY = "updateGlobalPluginScript";
    private static final String UPDATE_GLOBAL_PLUGIN_ORDER_PROPERTY = "updateGlobalPluginOrder";

    public static void updateGlobalPlugin(Cell cell, DeploymentPlanningContext ctx) {
        ctx.addStep(new PythonDeploymentStep(
                cell.<Integer>getProperty(UPDATE_GLOBAL_PLUGIN_ORDER_PROPERTY), cell, 
                cell.<String>getProperty(UPDATE_GLOBAL_PLUGIN_SCRIPT_PROPERTY), 
                ImmutableMap.<String, Object>of("container", cell), 
                format("Update global Web Server plugin configuration for '%s'", cell.getName())));
    }
}
