providerContainmentPath = '%s/ResourceEnvironmentProvider:%s' % (deployed.container.containmentPath, deployed.provider)
providerId = validateNotEmpty(AdminConfig.getid(providerContainmentPath), "Cannot find WebSphere Resource Environment Provider " + deployed.provider);
args = toAdminConfigArgs(deployed.getExposedProperties())

print "Creating Resource Environment Entry for provider %s with args %s " % (providerId, args)
envEntryId = AdminConfig.create('ResourceEnvEntry', providerId, args)

if hasattr(deployed, 'customProperties'):
  customPropSetId = AdminConfig.showAttribute(envEntryId, 'propertySet')  
  if customPropSetId is None:
    print "Creating custom property set for '%s'" % (envEntryId)
    customPropSetId = AdminConfig.create('J2EEResourcePropertySet', envEntryId, [])
  for name,value in deployed.customProperties.items():
    print "Creating custom property '%s'" % (name)
    AdminConfig.create('J2EEResourceProperty', customPropSetId, [['name', name], ['value', value]])