/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.step;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereFileCopier;
import java.io.Closeable;

public class PluginConfigurationCopyStep
implements DeploymentStep {
    private ManagedWebServer webserver;
    private int copyStepOrder;
    private final String pluginSrcFilePath;
    private final String pluginDestFilePath;

    public PluginConfigurationCopyStep(int n, ManagedWebServer managedWebServer) {
        this.copyStepOrder = n;
        this.webserver = managedWebServer;
        this.pluginSrcFilePath = managedWebServer.getNode().getCell().getWasHome() + "/config/cells/" + managedWebServer.getNode().getCell().getCellName() + "/nodes/" + managedWebServer.getNode().getNodeName() + "/servers/" + managedWebServer.getName().trim() + "/plugin-cfg.xml";
        this.pluginDestFilePath = (String)managedWebServer.getProperty("pluginConfigurationPath");
    }

    public String getDescription() {
        return String.format("Copy WebSphere plugin configuration file for unmanaged webserver " + this.webserver.getName(), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(DeploymentExecutionContext deploymentExecutionContext) throws Exception {
        OverthereConnection overthereConnection = this.webserver.getNode().getCell().getHost().getConnection();
        OverthereConnection overthereConnection2 = ((Host)this.webserver.getProperty("host")).getConnection();
        try {
            OverthereFile overthereFile = overthereConnection.getFile(this.pluginSrcFilePath);
            OverthereFile overthereFile2 = overthereConnection2.getFile(this.pluginDestFilePath);
            deploymentExecutionContext.logOutput(String.format("Copying generated plugin configuration file from %s to %s", this.pluginSrcFilePath, this.pluginDestFilePath));
            OverthereFileCopier.copy((OverthereFile)overthereFile, (OverthereFile)overthereFile2);
        }
        finally {
            Closeables.closeQuietly((Closeable)overthereConnection);
            Closeables.closeQuietly((Closeable)overthereConnection2);
        }
        return Step.Result.Success;
    }

    public int getOrder() {
        return this.copyStepOrder;
    }
}

