/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.planning;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.planning.SingleTypeContributor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;
import java.util.Set;

public abstract class ReferencedWebserverContributor
extends SingleTypeContributor<ExtensibleDeployedArtifact> {
    private static final String WEBSERVERS_PROPERTY = "webServers";
    private static final Predicate<ConfigurationItem> IS_EAR_OR_WAR_MODULE = Predicates.or(com.xebialabs.deployit.plugin.api.util.Predicates.instanceOf(Type.valueOf((String)"was.EarModule")), com.xebialabs.deployit.plugin.api.util.Predicates.instanceOf(Type.valueOf((String)"was.WarModule")));

    public ReferencedWebserverContributor() {
        super(ExtensibleDeployedArtifact.class);
    }

    protected Set<ManagedWebServer> getReferencedWebservers() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ExtensibleDeployedArtifact extensibleDeployedArtifact : this.getEarAndWarModules()) {
            Set set = (Set)extensibleDeployedArtifact.getProperty(WEBSERVERS_PROPERTY);
            if (set == null) continue;
            builder.addAll((Iterable)set);
        }
        return builder.build();
    }

    private Set<ExtensibleDeployedArtifact> getEarAndWarModules() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(Iterables.filter((Iterable)Iterables.concat((Iterable)this.deployedsCreated, (Iterable)this.deployedsRemoved), IS_EAR_OR_WAR_MODULE));
        Iterable iterable = Iterables.filter((Iterable)Iterables.concat((Iterable)this.deployedsModified, (Iterable)this.deployedsNoop), (Predicate)new Predicate<SingleTypeContributor.TypedDelta>(){

            public boolean apply(SingleTypeContributor.TypedDelta typedDelta) {
                return IS_EAR_OR_WAR_MODULE.apply(typedDelta.getDeployed());
            }
        });
        for (SingleTypeContributor.TypedDelta typedDelta : iterable) {
            builder.add(typedDelta.getPrevious());
            builder.add(typedDelta.getDeployed());
        }
        return builder.build();
    }
}

