def findJaasAuthData(alias):
  jaasAuthDatas = AdminConfig.list('JAASAuthData')
  if jaasAuthDatas == '':
    return None
  for jaasAuthData in jaasAuthDatas.splitlines():
    if AdminConfig.showAttribute(jaasAuthData, 'alias') == alias:
      return jaasAuthData
  return None

providerContainmentPath = '%s/JDBCProvider:%s' % (deployed.container.containmentPath, deployed.jdbcProvider)
providerId = validateNotEmpty(AdminConfig.getid(providerContainmentPath), "Cannot find JDBC Provider " + deployed.jdbcProvider + " in scope " + deployed.container.name)

# Create JAAS authentication data
if (deployed.jaasAliasName is None) or (deployed.jaasAliasName == ''):
  jaasName = deployed.container.shortTypeDescription + '_' + deployed.container.name + '_' + deployed.name + '_user'
else:
  jaasName = deployed.jaasAliasName
  
securityId = AdminConfig.list('Security')

authdataId = findJaasAuthData(jaasName)
if (authdataId is not None):
  if (deployed.allowExistingJaasAlias):
    print "WARN: Using existing JAAS/J2C authentication data with alias '%s'" % (jaasName)
  else:
    print "ERROR: JAAS/J2C authentication data with alias '%s' already exists" % (jaasName)
    sys.exit(1)
else:
  print "Creating JAAS/J2C authentication data '%s'" % (jaasName)
  authdataId = AdminConfig.create('JAASAuthData', securityId, [['alias', jaasName], ['userId', deployed.username], ['password', deployed.password]])

# Create JDBC DataSource
createParams = [["authDataAlias" , jaasName], ['name', deployed.name], ['description', deployed.description], ['jndiName', deployed.jndiName], ['datasourceHelperClassname', deployed.datasourceHelperClassname]]
print "Creating JDBC DataSource %s: %s" % (deployed.name, createParams)
datasourceId = AdminConfig.create('DataSource', providerId, createParams)

# Set additional properties
propertySet = AdminConfig.create('J2EEResourcePropertySet', datasourceId, [])
for propName, propValue in deployed.getExposedProperties().items():
    if propValue != None:
        args = [['name', propName],['value', propValue]]
        print "Creating J2EE Resource Property: %s" %(args)
        AdminConfig.create('J2EEResourceProperty', propertySet, args)

# Set connection pool properties
if hasattr(deployed, 'ConnectionPool'):
    poolArgs = toAdminConfigArgs(deployed.ConnectionPool.getExposedProperties())
    print "Creating ConnectionPool: %s" %(poolArgs)
    AdminConfig.create('ConnectionPool', datasourceId, poolArgs)
