package com.xebialabs.deployit.community.wasext.planning;


import java.util.Set;

import com.google.common.base.Function;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;

import static com.google.common.collect.Iterables.transform;
import static com.xebialabs.deployit.community.wasext.task.CellTasks.updateGlobalPlugin;
import static com.xebialabs.deployit.community.wasext.task.ManagedWebServerTasks.generatePlugin;
import static com.xebialabs.deployit.community.wasext.task.ManagedWebServerTasks.propagatePlugin;
import static java.lang.Boolean.TRUE;

public class GenerateAndPropagateWebserverPlugin extends ReferencedWebserverContributor {
    private static final String WEBSERVER_UPDATE_PLUGIN_PROPERTY = "updatePlugin";
    
    @Contributor
    public void generateAndPropagateWebserverPlugin(Deltas deltas, DeploymentPlanningContext ctx) {
        filterDeltas(deltas.getDeltas());

        Set<ManagedWebServer> referencedWebservers = getReferencedWebservers();

        for (ManagedWebServer webserver : referencedWebservers) {
            // may be null
            if (TRUE.equals(webserver.getProperty(WEBSERVER_UPDATE_PLUGIN_PROPERTY))) {
                generatePlugin(webserver, ctx);
                propagatePlugin(webserver, ctx);
            }
        }
    }
}
